// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a scaling plan.
 */
class ScalingPlan private constructor(builder: BuilderImpl) {
    /**
     * A CloudFormation stack or a set of tags. You can create one scaling plan per application
     * source.
     */
    val applicationSource: ApplicationSource? = builder.applicationSource
    /**
     * The Unix time stamp when the scaling plan was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The scaling instructions.
     */
    val scalingInstructions: List<ScalingInstruction>? = builder.scalingInstructions
    /**
     * The name of the scaling plan.
     */
    val scalingPlanName: String? = builder.scalingPlanName
    /**
     * The version number of the scaling plan.
     */
    val scalingPlanVersion: Long? = builder.scalingPlanVersion
    /**
     * The status of the scaling plan.
     * Active - The scaling plan is active.
     * ActiveWithProblems - The scaling plan is active, but the scaling
     * configuration for one or more resources could not be applied.
     * CreationInProgress - The scaling plan is being created.
     * CreationFailed - The scaling plan could not be created.
     * DeletionInProgress - The scaling plan is being deleted.
     * DeletionFailed - The scaling plan could not be deleted.
     * UpdateInProgress - The scaling plan is being updated.
     * UpdateFailed - The scaling plan could not be updated.
     */
    val statusCode: ScalingPlanStatusCode? = builder.statusCode
    /**
     * A simple message about the current status of the scaling plan.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The Unix time stamp when the scaling plan entered the current status.
     */
    val statusStartTime: Instant? = builder.statusStartTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalingPlan = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPlan(")
        append("applicationSource=$applicationSource,")
        append("creationTime=$creationTime,")
        append("scalingInstructions=$scalingInstructions,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("statusCode=$statusCode,")
        append("statusMessage=$statusMessage,")
        append("statusStartTime=$statusStartTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSource?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (scalingInstructions?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanName?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (statusStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalingPlan

        if (applicationSource != other.applicationSource) return false
        if (creationTime != other.creationTime) return false
        if (scalingInstructions != other.scalingInstructions) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (statusCode != other.statusCode) return false
        if (statusMessage != other.statusMessage) return false
        if (statusStartTime != other.statusStartTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalingPlan = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalingPlan
        /**
         * A CloudFormation stack or a set of tags. You can create one scaling plan per application
         * source.
         */
        fun applicationSource(applicationSource: ApplicationSource): FluentBuilder
        /**
         * The Unix time stamp when the scaling plan was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The scaling instructions.
         */
        fun scalingInstructions(scalingInstructions: List<ScalingInstruction>): FluentBuilder
        /**
         * The name of the scaling plan.
         */
        fun scalingPlanName(scalingPlanName: String): FluentBuilder
        /**
         * The version number of the scaling plan.
         */
        fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder
        /**
         * The status of the scaling plan.
         * Active - The scaling plan is active.
         * ActiveWithProblems - The scaling plan is active, but the scaling
         * configuration for one or more resources could not be applied.
         * CreationInProgress - The scaling plan is being created.
         * CreationFailed - The scaling plan could not be created.
         * DeletionInProgress - The scaling plan is being deleted.
         * DeletionFailed - The scaling plan could not be deleted.
         * UpdateInProgress - The scaling plan is being updated.
         * UpdateFailed - The scaling plan could not be updated.
         */
        fun statusCode(statusCode: ScalingPlanStatusCode): FluentBuilder
        /**
         * A simple message about the current status of the scaling plan.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The Unix time stamp when the scaling plan entered the current status.
         */
        fun statusStartTime(statusStartTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A CloudFormation stack or a set of tags. You can create one scaling plan per application
         * source.
         */
        var applicationSource: ApplicationSource?
        /**
         * The Unix time stamp when the scaling plan was created.
         */
        var creationTime: Instant?
        /**
         * The scaling instructions.
         */
        var scalingInstructions: List<ScalingInstruction>?
        /**
         * The name of the scaling plan.
         */
        var scalingPlanName: String?
        /**
         * The version number of the scaling plan.
         */
        var scalingPlanVersion: Long?
        /**
         * The status of the scaling plan.
         * Active - The scaling plan is active.
         * ActiveWithProblems - The scaling plan is active, but the scaling
         * configuration for one or more resources could not be applied.
         * CreationInProgress - The scaling plan is being created.
         * CreationFailed - The scaling plan could not be created.
         * DeletionInProgress - The scaling plan is being deleted.
         * DeletionFailed - The scaling plan could not be deleted.
         * UpdateInProgress - The scaling plan is being updated.
         * UpdateFailed - The scaling plan could not be updated.
         */
        var statusCode: ScalingPlanStatusCode?
        /**
         * A simple message about the current status of the scaling plan.
         */
        var statusMessage: String?
        /**
         * The Unix time stamp when the scaling plan entered the current status.
         */
        var statusStartTime: Instant?

        fun build(): ScalingPlan
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource] inside the given [block]
         */
        fun applicationSource(block: ApplicationSource.DslBuilder.() -> kotlin.Unit) {
            this.applicationSource = ApplicationSource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationSource: ApplicationSource? = null
        override var creationTime: Instant? = null
        override var scalingInstructions: List<ScalingInstruction>? = null
        override var scalingPlanName: String? = null
        override var scalingPlanVersion: Long? = null
        override var statusCode: ScalingPlanStatusCode? = null
        override var statusMessage: String? = null
        override var statusStartTime: Instant? = null

        constructor(x: ScalingPlan) : this() {
            this.applicationSource = x.applicationSource
            this.creationTime = x.creationTime
            this.scalingInstructions = x.scalingInstructions
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.statusCode = x.statusCode
            this.statusMessage = x.statusMessage
            this.statusStartTime = x.statusStartTime
        }

        override fun build(): ScalingPlan = ScalingPlan(this)
        override fun applicationSource(applicationSource: ApplicationSource): FluentBuilder = apply { this.applicationSource = applicationSource }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun scalingInstructions(scalingInstructions: List<ScalingInstruction>): FluentBuilder = apply { this.scalingInstructions = scalingInstructions }
        override fun scalingPlanName(scalingPlanName: String): FluentBuilder = apply { this.scalingPlanName = scalingPlanName }
        override fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder = apply { this.scalingPlanVersion = scalingPlanVersion }
        override fun statusCode(statusCode: ScalingPlanStatusCode): FluentBuilder = apply { this.statusCode = statusCode }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun statusStartTime(statusStartTime: Instant): FluentBuilder = apply { this.statusStartTime = statusStartTime }
    }
}
