// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Describes a scaling instruction for a scalable resource in a scaling plan. Each scaling
 * instruction applies to one resource.
 * AWS Auto Scaling creates target tracking scaling policies based on the scaling instructions.
 * Target tracking scaling policies adjust the capacity of your scalable resource as required
 * to maintain resource utilization at the target value that you specified.
 * AWS Auto Scaling also configures predictive scaling for your Amazon EC2 Auto Scaling groups using a subset of
 * parameters, including the load metric, the scaling metric, the target value for the scaling
 * metric, the predictive scaling mode (forecast and scale or forecast only), and the desired
 * behavior when the forecast capacity exceeds the maximum capacity of the resource. With
 * predictive scaling, AWS Auto Scaling generates forecasts with traffic predictions for the two days
 * ahead and schedules scaling actions that proactively add and remove resource capacity to
 * match the forecast.
 * We recommend waiting a minimum of 24 hours after creating an Auto Scaling group to configure
 * predictive scaling. At minimum, there must be 24 hours of historical data to generate a
 * forecast. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-best-practices.html">Best Practices for
 * AWS Auto Scaling in the AWS Auto Scaling User Guide.
 */
class ScalingInstruction private constructor(builder: BuilderImpl) {
    /**
     * The customized load metric to use for predictive scaling. This parameter or a PredefinedLoadMetricSpecification is required when configuring
     * predictive scaling, and cannot be used otherwise.
     */
    val customizedLoadMetricSpecification: CustomizedLoadMetricSpecification? = builder.customizedLoadMetricSpecification
    /**
     * Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is
     * enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target
     * tracking configurations.
     * The default is enabled (false).
     */
    val disableDynamicScaling: Boolean? = builder.disableDynamicScaling
    /**
     * The maximum capacity of the resource. The exception to this upper limit is if you
     * specify a non-default setting for PredictiveScalingMaxCapacityBehavior.
     */
    val maxCapacity: Int? = builder.maxCapacity
    /**
     * The minimum capacity of the resource.
     */
    val minCapacity: Int? = builder.minCapacity
    /**
     * The predefined load metric to use for predictive scaling. This parameter or a CustomizedLoadMetricSpecification is required when configuring
     * predictive scaling, and cannot be used otherwise.
     */
    val predefinedLoadMetricSpecification: PredefinedLoadMetricSpecification? = builder.predefinedLoadMetricSpecification
    /**
     * Defines the behavior that should be applied if the forecast capacity approaches or
     * exceeds the maximum capacity specified for the resource. The default value is
     * SetForecastCapacityToMaxCapacity.
     * The following are possible values:
     * SetForecastCapacityToMaxCapacity - AWS Auto Scaling cannot scale resource
     * capacity higher than the maximum capacity. The maximum capacity is enforced as a hard
     * limit.
     * SetMaxCapacityToForecastCapacity - AWS Auto Scaling may scale resource
     * capacity higher than the maximum capacity to equal but not exceed forecast
     * capacity.
     * SetMaxCapacityAboveForecastCapacity - AWS Auto Scaling may scale resource
     * capacity higher than the maximum capacity by a specified buffer value. The intention
     * is to give the target tracking scaling policy extra capacity if unexpected traffic
     * occurs.
     * Only valid when configuring predictive scaling.
     */
    val predictiveScalingMaxCapacityBehavior: PredictiveScalingMaxCapacityBehavior? = builder.predictiveScalingMaxCapacityBehavior
    /**
     * The size of the capacity buffer to use when the forecast capacity is close to or exceeds
     * the maximum capacity. The value is specified as a percentage relative to the forecast
     * capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if
     * the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum
     * capacity is 55.
     * Only valid when configuring predictive scaling. Required if the PredictiveScalingMaxCapacityBehavior is set to
     * SetMaxCapacityAboveForecastCapacity, and cannot be used otherwise.
     * The range is 1-100.
     */
    val predictiveScalingMaxCapacityBuffer: Int? = builder.predictiveScalingMaxCapacityBuffer
    /**
     * The predictive scaling mode. The default value is ForecastAndScale.
     * Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions
     * based on the capacity forecast.
     */
    val predictiveScalingMode: PredictiveScalingMode? = builder.predictiveScalingMode
    /**
     * The ID of the resource. This string consists of the resource type and unique
     * identifier.
     * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
     * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The scalable dimension associated with the resource.
     * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * Controls whether a resource's externally created scaling policies are kept or replaced.
     * The default value is KeepExternalPolicies. If the parameter is set to
     * ReplaceExternalPolicies, any scaling policies that are external to AWS Auto Scaling
     * are deleted and new target tracking scaling policies created.
     * Only valid when configuring dynamic scaling.
     * Condition: The number of existing policies to be replaced must be less than or equal to
     * 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies
     * and does not create new ones.
     */
    val scalingPolicyUpdateBehavior: ScalingPolicyUpdateBehavior? = builder.scalingPolicyUpdateBehavior
    /**
     * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when
     * scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer
     * time is 5 minutes, then the run time of the corresponding scheduled scaling action will be
     * 9:55 AM. The intention is to give resources time to be provisioned. For example, it can
     * take a few minutes to launch an EC2 instance. The actual amount of time required depends on
     * several factors, such as the size of the instance and whether there are startup scripts to
     * complete.
     * The value must be less than the forecast interval duration of 3600 seconds (60 minutes).
     * The default is 300 seconds.
     * Only valid when configuring predictive scaling.
     */
    val scheduledActionBufferTime: Int? = builder.scheduledActionBufferTime
    /**
     * The namespace of the AWS service.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace
    /**
     * The target tracking configurations (up to 10). Each of these structures must specify a
     * unique scaling metric and a target value for the metric.
     */
    val targetTrackingConfigurations: List<TargetTrackingConfiguration>? = builder.targetTrackingConfigurations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalingInstruction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingInstruction(")
        append("customizedLoadMetricSpecification=$customizedLoadMetricSpecification,")
        append("disableDynamicScaling=$disableDynamicScaling,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("predefinedLoadMetricSpecification=$predefinedLoadMetricSpecification,")
        append("predictiveScalingMaxCapacityBehavior=$predictiveScalingMaxCapacityBehavior,")
        append("predictiveScalingMaxCapacityBuffer=$predictiveScalingMaxCapacityBuffer,")
        append("predictiveScalingMode=$predictiveScalingMode,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPolicyUpdateBehavior=$scalingPolicyUpdateBehavior,")
        append("scheduledActionBufferTime=$scheduledActionBufferTime,")
        append("serviceNamespace=$serviceNamespace,")
        append("targetTrackingConfigurations=$targetTrackingConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedLoadMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableDynamicScaling?.hashCode() ?: 0)
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (minCapacity ?: 0)
        result = 31 * result + (predefinedLoadMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingMaxCapacityBehavior?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingMaxCapacityBuffer ?: 0)
        result = 31 * result + (predictiveScalingMode?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalingPolicyUpdateBehavior?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionBufferTime ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (targetTrackingConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalingInstruction

        if (customizedLoadMetricSpecification != other.customizedLoadMetricSpecification) return false
        if (disableDynamicScaling != other.disableDynamicScaling) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (predefinedLoadMetricSpecification != other.predefinedLoadMetricSpecification) return false
        if (predictiveScalingMaxCapacityBehavior != other.predictiveScalingMaxCapacityBehavior) return false
        if (predictiveScalingMaxCapacityBuffer != other.predictiveScalingMaxCapacityBuffer) return false
        if (predictiveScalingMode != other.predictiveScalingMode) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPolicyUpdateBehavior != other.scalingPolicyUpdateBehavior) return false
        if (scheduledActionBufferTime != other.scheduledActionBufferTime) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (targetTrackingConfigurations != other.targetTrackingConfigurations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalingInstruction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalingInstruction
        /**
         * The customized load metric to use for predictive scaling. This parameter or a PredefinedLoadMetricSpecification is required when configuring
         * predictive scaling, and cannot be used otherwise.
         */
        fun customizedLoadMetricSpecification(customizedLoadMetricSpecification: CustomizedLoadMetricSpecification): FluentBuilder
        /**
         * Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is
         * enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target
         * tracking configurations.
         * The default is enabled (false).
         */
        fun disableDynamicScaling(disableDynamicScaling: Boolean): FluentBuilder
        /**
         * The maximum capacity of the resource. The exception to this upper limit is if you
         * specify a non-default setting for PredictiveScalingMaxCapacityBehavior.
         */
        fun maxCapacity(maxCapacity: Int): FluentBuilder
        /**
         * The minimum capacity of the resource.
         */
        fun minCapacity(minCapacity: Int): FluentBuilder
        /**
         * The predefined load metric to use for predictive scaling. This parameter or a CustomizedLoadMetricSpecification is required when configuring
         * predictive scaling, and cannot be used otherwise.
         */
        fun predefinedLoadMetricSpecification(predefinedLoadMetricSpecification: PredefinedLoadMetricSpecification): FluentBuilder
        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or
         * exceeds the maximum capacity specified for the resource. The default value is
         * SetForecastCapacityToMaxCapacity.
         * The following are possible values:
         * SetForecastCapacityToMaxCapacity - AWS Auto Scaling cannot scale resource
         * capacity higher than the maximum capacity. The maximum capacity is enforced as a hard
         * limit.
         * SetMaxCapacityToForecastCapacity - AWS Auto Scaling may scale resource
         * capacity higher than the maximum capacity to equal but not exceed forecast
         * capacity.
         * SetMaxCapacityAboveForecastCapacity - AWS Auto Scaling may scale resource
         * capacity higher than the maximum capacity by a specified buffer value. The intention
         * is to give the target tracking scaling policy extra capacity if unexpected traffic
         * occurs.
         * Only valid when configuring predictive scaling.
         */
        fun predictiveScalingMaxCapacityBehavior(predictiveScalingMaxCapacityBehavior: PredictiveScalingMaxCapacityBehavior): FluentBuilder
        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds
         * the maximum capacity. The value is specified as a percentage relative to the forecast
         * capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if
         * the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum
         * capacity is 55.
         * Only valid when configuring predictive scaling. Required if the PredictiveScalingMaxCapacityBehavior is set to
         * SetMaxCapacityAboveForecastCapacity, and cannot be used otherwise.
         * The range is 1-100.
         */
        fun predictiveScalingMaxCapacityBuffer(predictiveScalingMaxCapacityBuffer: Int): FluentBuilder
        /**
         * The predictive scaling mode. The default value is ForecastAndScale.
         * Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions
         * based on the capacity forecast.
         */
        fun predictiveScalingMode(predictiveScalingMode: PredictiveScalingMode): FluentBuilder
        /**
         * The ID of the resource. This string consists of the resource type and unique
         * identifier.
         * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
         * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The scalable dimension associated with the resource.
         * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * Controls whether a resource's externally created scaling policies are kept or replaced.
         * The default value is KeepExternalPolicies. If the parameter is set to
         * ReplaceExternalPolicies, any scaling policies that are external to AWS Auto Scaling
         * are deleted and new target tracking scaling policies created.
         * Only valid when configuring dynamic scaling.
         * Condition: The number of existing policies to be replaced must be less than or equal to
         * 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies
         * and does not create new ones.
         */
        fun scalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior: ScalingPolicyUpdateBehavior): FluentBuilder
        /**
         * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when
         * scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer
         * time is 5 minutes, then the run time of the corresponding scheduled scaling action will be
         * 9:55 AM. The intention is to give resources time to be provisioned. For example, it can
         * take a few minutes to launch an EC2 instance. The actual amount of time required depends on
         * several factors, such as the size of the instance and whether there are startup scripts to
         * complete.
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes).
         * The default is 300 seconds.
         * Only valid when configuring predictive scaling.
         */
        fun scheduledActionBufferTime(scheduledActionBufferTime: Int): FluentBuilder
        /**
         * The namespace of the AWS service.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
        /**
         * The target tracking configurations (up to 10). Each of these structures must specify a
         * unique scaling metric and a target value for the metric.
         */
        fun targetTrackingConfigurations(targetTrackingConfigurations: List<TargetTrackingConfiguration>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The customized load metric to use for predictive scaling. This parameter or a PredefinedLoadMetricSpecification is required when configuring
         * predictive scaling, and cannot be used otherwise.
         */
        var customizedLoadMetricSpecification: CustomizedLoadMetricSpecification?
        /**
         * Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is
         * enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target
         * tracking configurations.
         * The default is enabled (false).
         */
        var disableDynamicScaling: Boolean?
        /**
         * The maximum capacity of the resource. The exception to this upper limit is if you
         * specify a non-default setting for PredictiveScalingMaxCapacityBehavior.
         */
        var maxCapacity: Int?
        /**
         * The minimum capacity of the resource.
         */
        var minCapacity: Int?
        /**
         * The predefined load metric to use for predictive scaling. This parameter or a CustomizedLoadMetricSpecification is required when configuring
         * predictive scaling, and cannot be used otherwise.
         */
        var predefinedLoadMetricSpecification: PredefinedLoadMetricSpecification?
        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or
         * exceeds the maximum capacity specified for the resource. The default value is
         * SetForecastCapacityToMaxCapacity.
         * The following are possible values:
         * SetForecastCapacityToMaxCapacity - AWS Auto Scaling cannot scale resource
         * capacity higher than the maximum capacity. The maximum capacity is enforced as a hard
         * limit.
         * SetMaxCapacityToForecastCapacity - AWS Auto Scaling may scale resource
         * capacity higher than the maximum capacity to equal but not exceed forecast
         * capacity.
         * SetMaxCapacityAboveForecastCapacity - AWS Auto Scaling may scale resource
         * capacity higher than the maximum capacity by a specified buffer value. The intention
         * is to give the target tracking scaling policy extra capacity if unexpected traffic
         * occurs.
         * Only valid when configuring predictive scaling.
         */
        var predictiveScalingMaxCapacityBehavior: PredictiveScalingMaxCapacityBehavior?
        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds
         * the maximum capacity. The value is specified as a percentage relative to the forecast
         * capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if
         * the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum
         * capacity is 55.
         * Only valid when configuring predictive scaling. Required if the PredictiveScalingMaxCapacityBehavior is set to
         * SetMaxCapacityAboveForecastCapacity, and cannot be used otherwise.
         * The range is 1-100.
         */
        var predictiveScalingMaxCapacityBuffer: Int?
        /**
         * The predictive scaling mode. The default value is ForecastAndScale.
         * Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions
         * based on the capacity forecast.
         */
        var predictiveScalingMode: PredictiveScalingMode?
        /**
         * The ID of the resource. This string consists of the resource type and unique
         * identifier.
         * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
         * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         */
        var resourceId: String?
        /**
         * The scalable dimension associated with the resource.
         * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        var scalableDimension: ScalableDimension?
        /**
         * Controls whether a resource's externally created scaling policies are kept or replaced.
         * The default value is KeepExternalPolicies. If the parameter is set to
         * ReplaceExternalPolicies, any scaling policies that are external to AWS Auto Scaling
         * are deleted and new target tracking scaling policies created.
         * Only valid when configuring dynamic scaling.
         * Condition: The number of existing policies to be replaced must be less than or equal to
         * 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies
         * and does not create new ones.
         */
        var scalingPolicyUpdateBehavior: ScalingPolicyUpdateBehavior?
        /**
         * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when
         * scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer
         * time is 5 minutes, then the run time of the corresponding scheduled scaling action will be
         * 9:55 AM. The intention is to give resources time to be provisioned. For example, it can
         * take a few minutes to launch an EC2 instance. The actual amount of time required depends on
         * several factors, such as the size of the instance and whether there are startup scripts to
         * complete.
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes).
         * The default is 300 seconds.
         * Only valid when configuring predictive scaling.
         */
        var scheduledActionBufferTime: Int?
        /**
         * The namespace of the AWS service.
         */
        var serviceNamespace: ServiceNamespace?
        /**
         * The target tracking configurations (up to 10). Each of these structures must specify a
         * unique scaling metric and a target value for the metric.
         */
        var targetTrackingConfigurations: List<TargetTrackingConfiguration>?

        fun build(): ScalingInstruction
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification] inside the given [block]
         */
        fun customizedLoadMetricSpecification(block: CustomizedLoadMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.customizedLoadMetricSpecification = CustomizedLoadMetricSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification] inside the given [block]
         */
        fun predefinedLoadMetricSpecification(block: PredefinedLoadMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.predefinedLoadMetricSpecification = PredefinedLoadMetricSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customizedLoadMetricSpecification: CustomizedLoadMetricSpecification? = null
        override var disableDynamicScaling: Boolean? = null
        override var maxCapacity: Int? = null
        override var minCapacity: Int? = null
        override var predefinedLoadMetricSpecification: PredefinedLoadMetricSpecification? = null
        override var predictiveScalingMaxCapacityBehavior: PredictiveScalingMaxCapacityBehavior? = null
        override var predictiveScalingMaxCapacityBuffer: Int? = null
        override var predictiveScalingMode: PredictiveScalingMode? = null
        override var resourceId: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var scalingPolicyUpdateBehavior: ScalingPolicyUpdateBehavior? = null
        override var scheduledActionBufferTime: Int? = null
        override var serviceNamespace: ServiceNamespace? = null
        override var targetTrackingConfigurations: List<TargetTrackingConfiguration>? = null

        constructor(x: ScalingInstruction) : this() {
            this.customizedLoadMetricSpecification = x.customizedLoadMetricSpecification
            this.disableDynamicScaling = x.disableDynamicScaling
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.predefinedLoadMetricSpecification = x.predefinedLoadMetricSpecification
            this.predictiveScalingMaxCapacityBehavior = x.predictiveScalingMaxCapacityBehavior
            this.predictiveScalingMaxCapacityBuffer = x.predictiveScalingMaxCapacityBuffer
            this.predictiveScalingMode = x.predictiveScalingMode
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPolicyUpdateBehavior = x.scalingPolicyUpdateBehavior
            this.scheduledActionBufferTime = x.scheduledActionBufferTime
            this.serviceNamespace = x.serviceNamespace
            this.targetTrackingConfigurations = x.targetTrackingConfigurations
        }

        override fun build(): ScalingInstruction = ScalingInstruction(this)
        override fun customizedLoadMetricSpecification(customizedLoadMetricSpecification: CustomizedLoadMetricSpecification): FluentBuilder = apply { this.customizedLoadMetricSpecification = customizedLoadMetricSpecification }
        override fun disableDynamicScaling(disableDynamicScaling: Boolean): FluentBuilder = apply { this.disableDynamicScaling = disableDynamicScaling }
        override fun maxCapacity(maxCapacity: Int): FluentBuilder = apply { this.maxCapacity = maxCapacity }
        override fun minCapacity(minCapacity: Int): FluentBuilder = apply { this.minCapacity = minCapacity }
        override fun predefinedLoadMetricSpecification(predefinedLoadMetricSpecification: PredefinedLoadMetricSpecification): FluentBuilder = apply { this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification }
        override fun predictiveScalingMaxCapacityBehavior(predictiveScalingMaxCapacityBehavior: PredictiveScalingMaxCapacityBehavior): FluentBuilder = apply { this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior }
        override fun predictiveScalingMaxCapacityBuffer(predictiveScalingMaxCapacityBuffer: Int): FluentBuilder = apply { this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer }
        override fun predictiveScalingMode(predictiveScalingMode: PredictiveScalingMode): FluentBuilder = apply { this.predictiveScalingMode = predictiveScalingMode }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun scalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior: ScalingPolicyUpdateBehavior): FluentBuilder = apply { this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior }
        override fun scheduledActionBufferTime(scheduledActionBufferTime: Int): FluentBuilder = apply { this.scheduledActionBufferTime = scheduledActionBufferTime }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
        override fun targetTrackingConfigurations(targetTrackingConfigurations: List<TargetTrackingConfiguration>): FluentBuilder = apply { this.targetTrackingConfigurations = targetTrackingConfigurations }
    }
}
