// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Represents a predefined metric that can be used for dynamic scaling as part of a target
 * tracking scaling policy.
 */
class PredefinedScalingMetricSpecification private constructor(builder: BuilderImpl) {
    /**
     * The metric type. The ALBRequestCountPerTarget metric type applies only to
     * Auto Scaling groups, Spot Fleet requests, and ECS services.
     */
    val predefinedScalingMetricType: ScalingMetricType? = builder.predefinedScalingMetricType
    /**
     * Identifies the resource associated with the metric type. You can't specify a resource
     * label unless the metric type is ALBRequestCountPerTarget and there is a target
     * group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or
     * ECS service.
     * You create the resource label by appending the final portion of the load balancer ARN
     * and the final portion of the target group ARN into a single value, separated by a forward
     * slash (/). The format is
     * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
     * where:
     * app/<load-balancer-name>/<load-balancer-id> is the final portion of
     * the load balancer ARN
     * targetgroup/<target-group-name>/<target-group-id> is the final portion
     * of the target group ARN.
     * This is an example:
     * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
     * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
     */
    val resourceLabel: String? = builder.resourceLabel

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PredefinedScalingMetricSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PredefinedScalingMetricSpecification(")
        append("predefinedScalingMetricType=$predefinedScalingMetricType,")
        append("resourceLabel=$resourceLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedScalingMetricType?.hashCode() ?: 0
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PredefinedScalingMetricSpecification

        if (predefinedScalingMetricType != other.predefinedScalingMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PredefinedScalingMetricSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PredefinedScalingMetricSpecification
        /**
         * The metric type. The ALBRequestCountPerTarget metric type applies only to
         * Auto Scaling groups, Spot Fleet requests, and ECS services.
         */
        fun predefinedScalingMetricType(predefinedScalingMetricType: ScalingMetricType): FluentBuilder
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBRequestCountPerTarget and there is a target
         * group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or
         * ECS service.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format is
         * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
         * where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        fun resourceLabel(resourceLabel: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The metric type. The ALBRequestCountPerTarget metric type applies only to
         * Auto Scaling groups, Spot Fleet requests, and ECS services.
         */
        var predefinedScalingMetricType: ScalingMetricType?
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBRequestCountPerTarget and there is a target
         * group for an Application Load Balancer attached to the Auto Scaling group, Spot Fleet request, or
         * ECS service.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format is
         * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
         * where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        var resourceLabel: String?

        fun build(): PredefinedScalingMetricSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var predefinedScalingMetricType: ScalingMetricType? = null
        override var resourceLabel: String? = null

        constructor(x: PredefinedScalingMetricSpecification) : this() {
            this.predefinedScalingMetricType = x.predefinedScalingMetricType
            this.resourceLabel = x.resourceLabel
        }

        override fun build(): PredefinedScalingMetricSpecification = PredefinedScalingMetricSpecification(this)
        override fun predefinedScalingMetricType(predefinedScalingMetricType: ScalingMetricType): FluentBuilder = apply { this.predefinedScalingMetricType = predefinedScalingMetricType }
        override fun resourceLabel(resourceLabel: String): FluentBuilder = apply { this.resourceLabel = resourceLabel }
    }
}
