// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Represents a predefined metric that can be used for predictive scaling.
 * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize
 * forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View
 * Scaling Information for a Resource in the
 * AWS Auto Scaling User Guide.
 */
class PredefinedLoadMetricSpecification private constructor(builder: BuilderImpl) {
    /**
     * The metric type.
     */
    val predefinedLoadMetricType: LoadMetricType? = builder.predefinedLoadMetricType
    /**
     * Identifies the resource associated with the metric type. You can't specify a resource
     * label unless the metric type is ALBTargetGroupRequestCount and there is a
     * target group for an Application Load Balancer attached to the Auto Scaling group.
     * You create the resource label by appending the final portion of the load balancer ARN
     * and the final portion of the target group ARN into a single value, separated by a forward
     * slash (/). The format is
     * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
     * where:
     * app/<load-balancer-name>/<load-balancer-id> is the final portion of
     * the load balancer ARN
     * targetgroup/<target-group-name>/<target-group-id> is the final portion
     * of the target group ARN.
     * This is an example:
     * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
     * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
     */
    val resourceLabel: String? = builder.resourceLabel

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PredefinedLoadMetricSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PredefinedLoadMetricSpecification(")
        append("predefinedLoadMetricType=$predefinedLoadMetricType,")
        append("resourceLabel=$resourceLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedLoadMetricType?.hashCode() ?: 0
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PredefinedLoadMetricSpecification

        if (predefinedLoadMetricType != other.predefinedLoadMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PredefinedLoadMetricSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PredefinedLoadMetricSpecification
        /**
         * The metric type.
         */
        fun predefinedLoadMetricType(predefinedLoadMetricType: LoadMetricType): FluentBuilder
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBTargetGroupRequestCount and there is a
         * target group for an Application Load Balancer attached to the Auto Scaling group.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format is
         * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
         * where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        fun resourceLabel(resourceLabel: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The metric type.
         */
        var predefinedLoadMetricType: LoadMetricType?
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource
         * label unless the metric type is ALBTargetGroupRequestCount and there is a
         * target group for an Application Load Balancer attached to the Auto Scaling group.
         * You create the resource label by appending the final portion of the load balancer ARN
         * and the final portion of the target group ARN into a single value, separated by a forward
         * slash (/). The format is
         * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
         * where:
         * app/<load-balancer-name>/<load-balancer-id> is the final portion of
         * the load balancer ARN
         * targetgroup/<target-group-name>/<target-group-id> is the final portion
         * of the target group ARN.
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers API operation. To find the ARN for the target group, use
         * the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups API operation.
         */
        var resourceLabel: String?

        fun build(): PredefinedLoadMetricSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var predefinedLoadMetricType: LoadMetricType? = null
        override var resourceLabel: String? = null

        constructor(x: PredefinedLoadMetricSpecification) : this() {
            this.predefinedLoadMetricType = x.predefinedLoadMetricType
            this.resourceLabel = x.resourceLabel
        }

        override fun build(): PredefinedLoadMetricSpecification = PredefinedLoadMetricSpecification(this)
        override fun predefinedLoadMetricType(predefinedLoadMetricType: LoadMetricType): FluentBuilder = apply { this.predefinedLoadMetricType = predefinedLoadMetricType }
        override fun resourceLabel(resourceLabel: String): FluentBuilder = apply { this.resourceLabel = resourceLabel }
    }
}
