// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.time.Instant

class GetScalingPlanResourceForecastDataRequest private constructor(builder: BuilderImpl) {
    /**
     * The exclusive end time of the time range for the forecast data to get. The maximum time
     * duration between the start and end time is seven days.
     * Although this parameter can accept a date and time that is more than two days in the
     * future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
     * periods of two days in advance.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The type of forecast data to get.
     * LoadForecast: The load metric forecast.
     * CapacityForecast: The capacity forecast.
     * ScheduledActionMinCapacity: The minimum capacity for each scheduled
     * scaling action. This data is calculated as the larger of two values: the capacity
     * forecast or the minimum capacity in the scaling instruction.
     * ScheduledActionMaxCapacity: The maximum capacity for each scheduled
     * scaling action. The calculation used is determined by the predictive scaling maximum
     * capacity behavior setting in the scaling instruction.
     */
    val forecastDataType: ForecastDataType? = builder.forecastDataType
    /**
     * The ID of the resource. This string consists of a prefix (autoScalingGroup)
     * followed by the name of a specified Auto Scaling group (my-asg). Example:
     * autoScalingGroup/my-asg.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The scalable dimension for the resource. The only valid value is
     * autoscaling:autoScalingGroup:DesiredCapacity.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * The name of the scaling plan.
     */
    val scalingPlanName: String? = builder.scalingPlanName
    /**
     * The version number of the scaling plan. Currently, the only valid value is
     * 1.
     */
    val scalingPlanVersion: Long? = builder.scalingPlanVersion
    /**
     * The namespace of the AWS service. The only valid value is autoscaling.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace
    /**
     * The inclusive start time of the time range for the forecast data to get. The date and
     * time can be at most 56 days before the current date and time.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetScalingPlanResourceForecastDataRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetScalingPlanResourceForecastDataRequest(")
        append("endTime=$endTime,")
        append("forecastDataType=$forecastDataType,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("serviceNamespace=$serviceNamespace,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (forecastDataType?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanName?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetScalingPlanResourceForecastDataRequest

        if (endTime != other.endTime) return false
        if (forecastDataType != other.forecastDataType) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetScalingPlanResourceForecastDataRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetScalingPlanResourceForecastDataRequest
        /**
         * The exclusive end time of the time range for the forecast data to get. The maximum time
         * duration between the start and end time is seven days.
         * Although this parameter can accept a date and time that is more than two days in the
         * future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
         * periods of two days in advance.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The type of forecast data to get.
         * LoadForecast: The load metric forecast.
         * CapacityForecast: The capacity forecast.
         * ScheduledActionMinCapacity: The minimum capacity for each scheduled
         * scaling action. This data is calculated as the larger of two values: the capacity
         * forecast or the minimum capacity in the scaling instruction.
         * ScheduledActionMaxCapacity: The maximum capacity for each scheduled
         * scaling action. The calculation used is determined by the predictive scaling maximum
         * capacity behavior setting in the scaling instruction.
         */
        fun forecastDataType(forecastDataType: ForecastDataType): FluentBuilder
        /**
         * The ID of the resource. This string consists of a prefix (autoScalingGroup)
         * followed by the name of a specified Auto Scaling group (my-asg). Example:
         * autoScalingGroup/my-asg.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The scalable dimension for the resource. The only valid value is
         * autoscaling:autoScalingGroup:DesiredCapacity.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * The name of the scaling plan.
         */
        fun scalingPlanName(scalingPlanName: String): FluentBuilder
        /**
         * The version number of the scaling plan. Currently, the only valid value is
         * 1.
         */
        fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder
        /**
         * The namespace of the AWS service. The only valid value is autoscaling.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
        /**
         * The inclusive start time of the time range for the forecast data to get. The date and
         * time can be at most 56 days before the current date and time.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The exclusive end time of the time range for the forecast data to get. The maximum time
         * duration between the start and end time is seven days.
         * Although this parameter can accept a date and time that is more than two days in the
         * future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for
         * periods of two days in advance.
         */
        var endTime: Instant?
        /**
         * The type of forecast data to get.
         * LoadForecast: The load metric forecast.
         * CapacityForecast: The capacity forecast.
         * ScheduledActionMinCapacity: The minimum capacity for each scheduled
         * scaling action. This data is calculated as the larger of two values: the capacity
         * forecast or the minimum capacity in the scaling instruction.
         * ScheduledActionMaxCapacity: The maximum capacity for each scheduled
         * scaling action. The calculation used is determined by the predictive scaling maximum
         * capacity behavior setting in the scaling instruction.
         */
        var forecastDataType: ForecastDataType?
        /**
         * The ID of the resource. This string consists of a prefix (autoScalingGroup)
         * followed by the name of a specified Auto Scaling group (my-asg). Example:
         * autoScalingGroup/my-asg.
         */
        var resourceId: String?
        /**
         * The scalable dimension for the resource. The only valid value is
         * autoscaling:autoScalingGroup:DesiredCapacity.
         */
        var scalableDimension: ScalableDimension?
        /**
         * The name of the scaling plan.
         */
        var scalingPlanName: String?
        /**
         * The version number of the scaling plan. Currently, the only valid value is
         * 1.
         */
        var scalingPlanVersion: Long?
        /**
         * The namespace of the AWS service. The only valid value is autoscaling.
         */
        var serviceNamespace: ServiceNamespace?
        /**
         * The inclusive start time of the time range for the forecast data to get. The date and
         * time can be at most 56 days before the current date and time.
         */
        var startTime: Instant?

        fun build(): GetScalingPlanResourceForecastDataRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var forecastDataType: ForecastDataType? = null
        override var resourceId: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var scalingPlanName: String? = null
        override var scalingPlanVersion: Long? = null
        override var serviceNamespace: ServiceNamespace? = null
        override var startTime: Instant? = null

        constructor(x: GetScalingPlanResourceForecastDataRequest) : this() {
            this.endTime = x.endTime
            this.forecastDataType = x.forecastDataType
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.serviceNamespace = x.serviceNamespace
            this.startTime = x.startTime
        }

        override fun build(): GetScalingPlanResourceForecastDataRequest = GetScalingPlanResourceForecastDataRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun forecastDataType(forecastDataType: ForecastDataType): FluentBuilder = apply { this.forecastDataType = forecastDataType }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun scalingPlanName(scalingPlanName: String): FluentBuilder = apply { this.scalingPlanName = scalingPlanName }
        override fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder = apply { this.scalingPlanVersion = scalingPlanVersion }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
