// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



class DescribeScalingPlansRequest private constructor(builder: BuilderImpl) {
    /**
     * The sources for the applications (up to 10). If you specify scaling plan names, you
     * cannot specify application sources.
     */
    val applicationSources: List<ApplicationSource>? = builder.applicationSources
    /**
     * The maximum number of scalable resources to return. This value can be between
     * 1 and 50. The default value is 50.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The names of the scaling plans (up to 10). If you specify application sources, you
     * cannot specify scaling plan names.
     */
    val scalingPlanNames: List<String>? = builder.scalingPlanNames
    /**
     * The version number of the scaling plan. Currently, the only valid value is
     * 1.
     * If you specify a scaling plan version, you must also specify a scaling plan
     * name.
     */
    val scalingPlanVersion: Long? = builder.scalingPlanVersion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeScalingPlansRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScalingPlansRequest(")
        append("applicationSources=$applicationSources,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scalingPlanNames=$scalingPlanNames,")
        append("scalingPlanVersion=$scalingPlanVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSources?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanNames?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeScalingPlansRequest

        if (applicationSources != other.applicationSources) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scalingPlanNames != other.scalingPlanNames) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeScalingPlansRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeScalingPlansRequest
        /**
         * The sources for the applications (up to 10). If you specify scaling plan names, you
         * cannot specify application sources.
         */
        fun applicationSources(applicationSources: List<ApplicationSource>): FluentBuilder
        /**
         * The maximum number of scalable resources to return. This value can be between
         * 1 and 50. The default value is 50.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The names of the scaling plans (up to 10). If you specify application sources, you
         * cannot specify scaling plan names.
         */
        fun scalingPlanNames(scalingPlanNames: List<String>): FluentBuilder
        /**
         * The version number of the scaling plan. Currently, the only valid value is
         * 1.
         * If you specify a scaling plan version, you must also specify a scaling plan
         * name.
         */
        fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The sources for the applications (up to 10). If you specify scaling plan names, you
         * cannot specify application sources.
         */
        var applicationSources: List<ApplicationSource>?
        /**
         * The maximum number of scalable resources to return. This value can be between
         * 1 and 50. The default value is 50.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * The names of the scaling plans (up to 10). If you specify application sources, you
         * cannot specify scaling plan names.
         */
        var scalingPlanNames: List<String>?
        /**
         * The version number of the scaling plan. Currently, the only valid value is
         * 1.
         * If you specify a scaling plan version, you must also specify a scaling plan
         * name.
         */
        var scalingPlanVersion: Long?

        fun build(): DescribeScalingPlansRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationSources: List<ApplicationSource>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var scalingPlanNames: List<String>? = null
        override var scalingPlanVersion: Long? = null

        constructor(x: DescribeScalingPlansRequest) : this() {
            this.applicationSources = x.applicationSources
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scalingPlanNames = x.scalingPlanNames
            this.scalingPlanVersion = x.scalingPlanVersion
        }

        override fun build(): DescribeScalingPlansRequest = DescribeScalingPlansRequest(this)
        override fun applicationSources(applicationSources: List<ApplicationSource>): FluentBuilder = apply { this.applicationSources = applicationSources }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun scalingPlanNames(scalingPlanNames: List<String>): FluentBuilder = apply { this.scalingPlanNames = scalingPlanNames }
        override fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder = apply { this.scalingPlanVersion = scalingPlanVersion }
    }
}
