// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Represents a CloudWatch metric of your choosing that can be used for dynamic scaling as part
 * of a target tracking scaling policy.
 * To create your customized scaling metric specification:
 * Add values for each required parameter from CloudWatch. You can use an existing metric,
 * or a new metric that you create. To use your own metric, you must first publish the
 * metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish Custom
 * Metrics in the Amazon CloudWatch User Guide.
 * Choose a metric that changes proportionally with capacity. The value of the metric
 * should increase or decrease in inverse proportion to the number of capacity units.
 * That is, the value of the metric should decrease when capacity increases.
 * For information about terminology, available metrics, or how to publish new metrics, see
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch
 * Concepts in the Amazon CloudWatch User Guide.
 */
class CustomizedScalingMetricSpecification private constructor(builder: BuilderImpl) {
    /**
     * The dimensions of the metric.
     * Conditional: If you published your metric with dimensions, you must specify the same
     * dimensions in your customized scaling metric specification.
     */
    val dimensions: List<MetricDimension>? = builder.dimensions
    /**
     * The name of the metric.
     */
    val metricName: String? = builder.metricName
    /**
     * The namespace of the metric.
     */
    val namespace: String? = builder.namespace
    /**
     * The statistic of the metric.
     */
    val statistic: MetricStatistic? = builder.statistic
    /**
     * The unit of the metric.
     */
    val unit: String? = builder.unit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomizedScalingMetricSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomizedScalingMetricSpecification(")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("statistic=$statistic,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomizedScalingMetricSpecification

        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (statistic != other.statistic) return false
        if (unit != other.unit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomizedScalingMetricSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomizedScalingMetricSpecification
        /**
         * The dimensions of the metric.
         * Conditional: If you published your metric with dimensions, you must specify the same
         * dimensions in your customized scaling metric specification.
         */
        fun dimensions(dimensions: List<MetricDimension>): FluentBuilder
        /**
         * The name of the metric.
         */
        fun metricName(metricName: String): FluentBuilder
        /**
         * The namespace of the metric.
         */
        fun namespace(namespace: String): FluentBuilder
        /**
         * The statistic of the metric.
         */
        fun statistic(statistic: MetricStatistic): FluentBuilder
        /**
         * The unit of the metric.
         */
        fun unit(unit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The dimensions of the metric.
         * Conditional: If you published your metric with dimensions, you must specify the same
         * dimensions in your customized scaling metric specification.
         */
        var dimensions: List<MetricDimension>?
        /**
         * The name of the metric.
         */
        var metricName: String?
        /**
         * The namespace of the metric.
         */
        var namespace: String?
        /**
         * The statistic of the metric.
         */
        var statistic: MetricStatistic?
        /**
         * The unit of the metric.
         */
        var unit: String?

        fun build(): CustomizedScalingMetricSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dimensions: List<MetricDimension>? = null
        override var metricName: String? = null
        override var namespace: String? = null
        override var statistic: MetricStatistic? = null
        override var unit: String? = null

        constructor(x: CustomizedScalingMetricSpecification) : this() {
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.statistic = x.statistic
            this.unit = x.unit
        }

        override fun build(): CustomizedScalingMetricSpecification = CustomizedScalingMetricSpecification(this)
        override fun dimensions(dimensions: List<MetricDimension>): FluentBuilder = apply { this.dimensions = dimensions }
        override fun metricName(metricName: String): FluentBuilder = apply { this.metricName = metricName }
        override fun namespace(namespace: String): FluentBuilder = apply { this.namespace = namespace }
        override fun statistic(statistic: MetricStatistic): FluentBuilder = apply { this.statistic = statistic }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
    }
}
