// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Represents a CloudWatch metric of your choosing that can be used for predictive scaling.
 * For predictive scaling to work with a customized load metric specification, AWS Auto Scaling
 * needs access to the Sum and Average statistics that CloudWatch computes
 * from metric data.
 * When you choose a load metric, make sure that the required Sum and
 * Average statistics for your metric are available in CloudWatch and that they
 * provide relevant data for predictive scaling. The Sum statistic must represent
 * the total load on the resource, and the Average statistic must represent the
 * average load per capacity unit of the resource. For example, there is a metric that counts
 * the number of requests processed by your Auto Scaling group. If the Sum statistic
 * represents the total request count processed by the group, then the Average
 * statistic for the specified metric must represent the average request count processed by
 * each instance of the group.
 * If you publish your own metrics, you can aggregate the data points at a given interval
 * and then publish the aggregated data points to CloudWatch. Before AWS Auto Scaling generates the
 * forecast, it sums up all the metric data points that occurred within each hour to match the
 * granularity period that is used in the forecast (60 minutes).
 * For information about terminology, available metrics, or how to publish new metrics, see
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch
 * Concepts in the Amazon CloudWatch User Guide.
 * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize
 * forecasts for the specified metric. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View
 * Scaling Information for a Resource in the
 * AWS Auto Scaling User Guide.
 */
class CustomizedLoadMetricSpecification private constructor(builder: BuilderImpl) {
    /**
     * The dimensions of the metric.
     * Conditional: If you published your metric with dimensions, you must specify the same
     * dimensions in your customized load metric specification.
     */
    val dimensions: List<MetricDimension>? = builder.dimensions
    /**
     * The name of the metric.
     */
    val metricName: String? = builder.metricName
    /**
     * The namespace of the metric.
     */
    val namespace: String? = builder.namespace
    /**
     * The statistic of the metric. The only valid value is Sum.
     */
    val statistic: MetricStatistic? = builder.statistic
    /**
     * The unit of the metric.
     */
    val unit: String? = builder.unit

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomizedLoadMetricSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomizedLoadMetricSpecification(")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("statistic=$statistic,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomizedLoadMetricSpecification

        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (statistic != other.statistic) return false
        if (unit != other.unit) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomizedLoadMetricSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomizedLoadMetricSpecification
        /**
         * The dimensions of the metric.
         * Conditional: If you published your metric with dimensions, you must specify the same
         * dimensions in your customized load metric specification.
         */
        fun dimensions(dimensions: List<MetricDimension>): FluentBuilder
        /**
         * The name of the metric.
         */
        fun metricName(metricName: String): FluentBuilder
        /**
         * The namespace of the metric.
         */
        fun namespace(namespace: String): FluentBuilder
        /**
         * The statistic of the metric. The only valid value is Sum.
         */
        fun statistic(statistic: MetricStatistic): FluentBuilder
        /**
         * The unit of the metric.
         */
        fun unit(unit: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The dimensions of the metric.
         * Conditional: If you published your metric with dimensions, you must specify the same
         * dimensions in your customized load metric specification.
         */
        var dimensions: List<MetricDimension>?
        /**
         * The name of the metric.
         */
        var metricName: String?
        /**
         * The namespace of the metric.
         */
        var namespace: String?
        /**
         * The statistic of the metric. The only valid value is Sum.
         */
        var statistic: MetricStatistic?
        /**
         * The unit of the metric.
         */
        var unit: String?

        fun build(): CustomizedLoadMetricSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dimensions: List<MetricDimension>? = null
        override var metricName: String? = null
        override var namespace: String? = null
        override var statistic: MetricStatistic? = null
        override var unit: String? = null

        constructor(x: CustomizedLoadMetricSpecification) : this() {
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.statistic = x.statistic
            this.unit = x.unit
        }

        override fun build(): CustomizedLoadMetricSpecification = CustomizedLoadMetricSpecification(this)
        override fun dimensions(dimensions: List<MetricDimension>): FluentBuilder = apply { this.dimensions = dimensions }
        override fun metricName(metricName: String): FluentBuilder = apply { this.metricName = metricName }
        override fun namespace(namespace: String): FluentBuilder = apply { this.namespace = namespace }
        override fun statistic(statistic: MetricStatistic): FluentBuilder = apply { this.statistic = statistic }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
    }
}
