// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



class CreateScalingPlanRequest private constructor(builder: BuilderImpl) {
    /**
     * A CloudFormation stack or set of tags. You can create one scaling plan per application
     * source.
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource in the AWS Auto Scaling API Reference.
     */
    val applicationSource: ApplicationSource? = builder.applicationSource
    /**
     * The scaling instructions.
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction in the AWS Auto Scaling API Reference.
     */
    val scalingInstructions: List<ScalingInstruction>? = builder.scalingInstructions
    /**
     * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
     * slashes.
     */
    val scalingPlanName: String? = builder.scalingPlanName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateScalingPlanRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScalingPlanRequest(")
        append("applicationSource=$applicationSource,")
        append("scalingInstructions=$scalingInstructions,")
        append("scalingPlanName=$scalingPlanName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSource?.hashCode() ?: 0
        result = 31 * result + (scalingInstructions?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateScalingPlanRequest

        if (applicationSource != other.applicationSource) return false
        if (scalingInstructions != other.scalingInstructions) return false
        if (scalingPlanName != other.scalingPlanName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateScalingPlanRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateScalingPlanRequest
        /**
         * A CloudFormation stack or set of tags. You can create one scaling plan per application
         * source.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource in the AWS Auto Scaling API Reference.
         */
        fun applicationSource(applicationSource: ApplicationSource): FluentBuilder
        /**
         * The scaling instructions.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction in the AWS Auto Scaling API Reference.
         */
        fun scalingInstructions(scalingInstructions: List<ScalingInstruction>): FluentBuilder
        /**
         * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
         * slashes.
         */
        fun scalingPlanName(scalingPlanName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A CloudFormation stack or set of tags. You can create one scaling plan per application
         * source.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ApplicationSource.html">ApplicationSource in the AWS Auto Scaling API Reference.
         */
        var applicationSource: ApplicationSource?
        /**
         * The scaling instructions.
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html">ScalingInstruction in the AWS Auto Scaling API Reference.
         */
        var scalingInstructions: List<ScalingInstruction>?
        /**
         * The name of the scaling plan. Names cannot contain vertical bars, colons, or forward
         * slashes.
         */
        var scalingPlanName: String?

        fun build(): CreateScalingPlanRequest
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource] inside the given [block]
         */
        fun applicationSource(block: ApplicationSource.DslBuilder.() -> kotlin.Unit) {
            this.applicationSource = ApplicationSource.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationSource: ApplicationSource? = null
        override var scalingInstructions: List<ScalingInstruction>? = null
        override var scalingPlanName: String? = null

        constructor(x: CreateScalingPlanRequest) : this() {
            this.applicationSource = x.applicationSource
            this.scalingInstructions = x.scalingInstructions
            this.scalingPlanName = x.scalingPlanName
        }

        override fun build(): CreateScalingPlanRequest = CreateScalingPlanRequest(this)
        override fun applicationSource(applicationSource: ApplicationSource): FluentBuilder = apply { this.applicationSource = applicationSource }
        override fun scalingInstructions(scalingInstructions: List<ScalingInstruction>): FluentBuilder = apply { this.scalingInstructions = scalingInstructions }
        override fun scalingPlanName(scalingPlanName: String): FluentBuilder = apply { this.scalingPlanName = scalingPlanName }
    }
}
