// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ServiceEndpointResolver
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.autoscalingplans.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.autoscalingplans.model.*
import aws.smithy.kotlin.runtime.http.middleware.RetryFeature
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

internal fun registerCreateScalingPlanMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<CreateScalingPlanRequest,CreateScalingPlanResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}

internal fun registerDeleteScalingPlanMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<DeleteScalingPlanRequest,DeleteScalingPlanResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}

internal fun registerDescribeScalingPlanResourcesMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<DescribeScalingPlanResourcesRequest,DescribeScalingPlanResourcesResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}

internal fun registerDescribeScalingPlansMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<DescribeScalingPlansRequest,DescribeScalingPlansResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}

internal fun registerGetScalingPlanResourceForecastDataMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<GetScalingPlanResourceForecastDataRequest,GetScalingPlanResourceForecastDataResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}

internal fun registerUpdateScalingPlanMiddleware(config: AutoScalingPlansClient.Config, op: SdkHttpOperation<UpdateScalingPlanRequest,UpdateScalingPlanResponse>) {
    op.apply {
        install(RetryFeature) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        install(ServiceEndpointResolver) {
            serviceId = ServiceId
            resolver = config.endpointResolver ?: DefaultEndpointResolver()
        }
        install(AwsJsonProtocol) {
            serviceShapeName = "AnyScaleScalingPlannerFrontendService"
            version = "1.1"
        }
        install(UserAgent) {
            metadata = awsUserAgentMetadata
        }
        install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider ?: DefaultChainCredentialsProvider()
            this.signingService = "autoscaling-plans"
        }
    }
}
