// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.region.resolveRegionForOperation
import aws.sdk.kotlin.services.autoscalingplans.model.*
import aws.sdk.kotlin.services.autoscalingplans.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Auto Scaling Plans"
const val ServiceApiVersion: String = "2018-01-06"
const val SdkVersion: String = "0.7.0-alpha"

internal class DefaultAutoScalingPlansClient(override val config: AutoScalingPlansClient.Config) : AutoScalingPlansClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Creates a scaling plan.
     */
    override suspend fun createScalingPlan(input: CreateScalingPlanRequest): CreateScalingPlanResponse {
        val op = SdkHttpOperation.build<CreateScalingPlanRequest, CreateScalingPlanResponse> {
            serializer = CreateScalingPlanOperationSerializer()
            deserializer = CreateScalingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateScalingPlan"
            }
        }
        registerCreateScalingPlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified scaling plan.
     * Deleting a scaling plan deletes the underlying ScalingInstruction for
     * all of the scalable resources that are covered by the plan.
     * If the plan has launched resources or has scaling activities in progress, you must
     * delete those resources separately.
     */
    override suspend fun deleteScalingPlan(input: DeleteScalingPlanRequest): DeleteScalingPlanResponse {
        val op = SdkHttpOperation.build<DeleteScalingPlanRequest, DeleteScalingPlanResponse> {
            serializer = DeleteScalingPlanOperationSerializer()
            deserializer = DeleteScalingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteScalingPlan"
            }
        }
        registerDeleteScalingPlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the scalable resources in the specified scaling plan.
     */
    override suspend fun describeScalingPlanResources(input: DescribeScalingPlanResourcesRequest): DescribeScalingPlanResourcesResponse {
        val op = SdkHttpOperation.build<DescribeScalingPlanResourcesRequest, DescribeScalingPlanResourcesResponse> {
            serializer = DescribeScalingPlanResourcesOperationSerializer()
            deserializer = DescribeScalingPlanResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScalingPlanResources"
            }
        }
        registerDescribeScalingPlanResourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more of your scaling plans.
     */
    override suspend fun describeScalingPlans(input: DescribeScalingPlansRequest): DescribeScalingPlansResponse {
        val op = SdkHttpOperation.build<DescribeScalingPlansRequest, DescribeScalingPlansResponse> {
            serializer = DescribeScalingPlansOperationSerializer()
            deserializer = DescribeScalingPlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeScalingPlans"
            }
        }
        registerDescribeScalingPlansMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the forecast data for a scalable resource.
     * Capacity forecasts are represented as predicted values, or data points, that are
     * calculated using historical data points from a specified CloudWatch load metric. Data points are
     * available for up to 56 days.
     */
    override suspend fun getScalingPlanResourceForecastData(input: GetScalingPlanResourceForecastDataRequest): GetScalingPlanResourceForecastDataResponse {
        val op = SdkHttpOperation.build<GetScalingPlanResourceForecastDataRequest, GetScalingPlanResourceForecastDataResponse> {
            serializer = GetScalingPlanResourceForecastDataOperationSerializer()
            deserializer = GetScalingPlanResourceForecastDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetScalingPlanResourceForecastData"
            }
        }
        registerGetScalingPlanResourceForecastDataMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified scaling plan.
     * You cannot update a scaling plan if it is in the process of being created, updated, or
     * deleted.
     */
    override suspend fun updateScalingPlan(input: UpdateScalingPlanRequest): UpdateScalingPlanResponse {
        val op = SdkHttpOperation.build<UpdateScalingPlanRequest, UpdateScalingPlanResponse> {
            serializer = UpdateScalingPlanOperationSerializer()
            deserializer = UpdateScalingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateScalingPlan"
            }
        }
        registerUpdateScalingPlanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
