// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.autoscalingplans.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS Auto Scaling</fullname>
 * Use AWS Auto Scaling to create scaling plans for your applications to
 * automatically scale your scalable AWS resources.
 * API Summary
 * You can use the AWS Auto Scaling service API to accomplish the following tasks:
 * Create and manage scaling plans
 * Define target tracking scaling policies to dynamically scale your resources based
 * on utilization
 * Scale Amazon EC2 Auto Scaling groups using predictive scaling and dynamic scaling to scale your
 * Amazon EC2 capacity faster
 * Set minimum and maximum capacity limits
 * Retrieve information on existing scaling plans
 * Access current forecast data and historical forecast data for up to 56 days
 * previous
 * To learn more about AWS Auto Scaling, including information about granting IAM users required
 * permissions for AWS Auto Scaling actions, see the <a href="https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html">AWS Auto Scaling User Guide.
 */
interface AutoScalingPlansClient : SdkClient {

    override val serviceName: String
        get() = "Auto Scaling Plans"
    /**
     * AutoScalingPlansClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): AutoScalingPlansClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultAutoScalingPlansClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Creates a scaling plan.
     */
    suspend fun createScalingPlan(input: CreateScalingPlanRequest): CreateScalingPlanResponse

    /**
     * Creates a scaling plan.
     */
    suspend fun createScalingPlan(block: CreateScalingPlanRequest.DslBuilder.() -> Unit) = createScalingPlan(CreateScalingPlanRequest.builder().apply(block).build())

    /**
     * Deletes the specified scaling plan.
     * Deleting a scaling plan deletes the underlying ScalingInstruction for
     * all of the scalable resources that are covered by the plan.
     * If the plan has launched resources or has scaling activities in progress, you must
     * delete those resources separately.
     */
    suspend fun deleteScalingPlan(input: DeleteScalingPlanRequest): DeleteScalingPlanResponse

    /**
     * Deletes the specified scaling plan.
     * Deleting a scaling plan deletes the underlying ScalingInstruction for
     * all of the scalable resources that are covered by the plan.
     * If the plan has launched resources or has scaling activities in progress, you must
     * delete those resources separately.
     */
    suspend fun deleteScalingPlan(block: DeleteScalingPlanRequest.DslBuilder.() -> Unit) = deleteScalingPlan(DeleteScalingPlanRequest.builder().apply(block).build())

    /**
     * Describes the scalable resources in the specified scaling plan.
     */
    suspend fun describeScalingPlanResources(input: DescribeScalingPlanResourcesRequest): DescribeScalingPlanResourcesResponse

    /**
     * Describes the scalable resources in the specified scaling plan.
     */
    suspend fun describeScalingPlanResources(block: DescribeScalingPlanResourcesRequest.DslBuilder.() -> Unit) = describeScalingPlanResources(DescribeScalingPlanResourcesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your scaling plans.
     */
    suspend fun describeScalingPlans(input: DescribeScalingPlansRequest): DescribeScalingPlansResponse

    /**
     * Describes one or more of your scaling plans.
     */
    suspend fun describeScalingPlans(block: DescribeScalingPlansRequest.DslBuilder.() -> Unit) = describeScalingPlans(DescribeScalingPlansRequest.builder().apply(block).build())

    /**
     * Retrieves the forecast data for a scalable resource.
     * Capacity forecasts are represented as predicted values, or data points, that are
     * calculated using historical data points from a specified CloudWatch load metric. Data points are
     * available for up to 56 days.
     */
    suspend fun getScalingPlanResourceForecastData(input: GetScalingPlanResourceForecastDataRequest): GetScalingPlanResourceForecastDataResponse

    /**
     * Retrieves the forecast data for a scalable resource.
     * Capacity forecasts are represented as predicted values, or data points, that are
     * calculated using historical data points from a specified CloudWatch load metric. Data points are
     * available for up to 56 days.
     */
    suspend fun getScalingPlanResourceForecastData(block: GetScalingPlanResourceForecastDataRequest.DslBuilder.() -> Unit) = getScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest.builder().apply(block).build())

    /**
     * Updates the specified scaling plan.
     * You cannot update a scaling plan if it is in the process of being created, updated, or
     * deleted.
     */
    suspend fun updateScalingPlan(input: UpdateScalingPlanRequest): UpdateScalingPlanResponse

    /**
     * Updates the specified scaling plan.
     * You cannot update a scaling plan if it is in the process of being created, updated, or
     * deleted.
     */
    suspend fun updateScalingPlan(block: UpdateScalingPlanRequest.DslBuilder.() -> Unit) = updateScalingPlan(UpdateScalingPlanRequest.builder().apply(block).build())
}
