// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.serde

import aws.sdk.kotlin.services.autoscalingplans.model.AutoScalingPlansException
import aws.sdk.kotlin.services.autoscalingplans.model.UpdateScalingPlanResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateScalingPlanOperationDeserializer: HttpDeserializer.NonStreaming<UpdateScalingPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateScalingPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateScalingPlanError(context, call, payload)
        }
        val builder = UpdateScalingPlanResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateScalingPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AutoScalingPlansException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingPlansException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
