// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a target tracking configuration to use with AWS Auto Scaling. Used with ScalingInstruction and ScalingPolicy.
 */
public class TargetTrackingConfiguration private constructor(builder: Builder) {
    /**
     * A customized metric. You can specify either a predefined metric or a customized metric.
     */
    public val customizedScalingMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification? = builder.customizedScalingMetricSpecification
    /**
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is `true`, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource.
     *
     * The default value is `false`.
     */
    public val disableScaleIn: kotlin.Boolean? = builder.disableScaleIn
    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.
     */
    public val estimatedInstanceWarmup: kotlin.Int? = builder.estimatedInstanceWarmup
    /**
     * A predefined metric. You can specify either a predefined metric or a customized metric.
     */
    public val predefinedScalingMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification? = builder.predefinedScalingMetricSpecification
    /**
     * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.
     *
     * With the *scale-in cooldown period*, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.
     */
    public val scaleInCooldown: kotlin.Int? = builder.scaleInCooldown
    /**
     * The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.
     *
     * With the *scale-out cooldown period*, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.
     */
    public val scaleOutCooldown: kotlin.Int? = builder.scaleOutCooldown
    /**
     * The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.
     */
    public val targetValue: kotlin.Double = requireNotNull(builder.targetValue) { "A non-null value must be provided for targetValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.TargetTrackingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingConfiguration(")
        append("customizedScalingMetricSpecification=$customizedScalingMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("estimatedInstanceWarmup=$estimatedInstanceWarmup,")
        append("predefinedScalingMetricSpecification=$predefinedScalingMetricSpecification,")
        append("scaleInCooldown=$scaleInCooldown,")
        append("scaleOutCooldown=$scaleOutCooldown,")
        append("targetValue=$targetValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedScalingMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (estimatedInstanceWarmup ?: 0)
        result = 31 * result + (predefinedScalingMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (scaleInCooldown ?: 0)
        result = 31 * result + (scaleOutCooldown ?: 0)
        result = 31 * result + (targetValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingConfiguration

        if (customizedScalingMetricSpecification != other.customizedScalingMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (estimatedInstanceWarmup != other.estimatedInstanceWarmup) return false
        if (predefinedScalingMetricSpecification != other.predefinedScalingMetricSpecification) return false
        if (scaleInCooldown != other.scaleInCooldown) return false
        if (scaleOutCooldown != other.scaleOutCooldown) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.TargetTrackingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A customized metric. You can specify either a predefined metric or a customized metric.
         */
        public var customizedScalingMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification? = null
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is `true`, scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable resource.
         *
         * The default value is `false`.
         */
        public var disableScaleIn: kotlin.Boolean? = null
        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.
         */
        public var estimatedInstanceWarmup: kotlin.Int? = null
        /**
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         */
        public var predefinedScalingMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification? = null
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling group.
         *
         * With the *scale-in cooldown period*, the intention is to scale in conservatively to protect your application’s availability, so scale-in activities are blocked until the cooldown period has expired. However, if another alarm triggers a scale-out activity during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case, the scale-in cooldown period stops and doesn't complete.
         */
        public var scaleInCooldown: kotlin.Int? = null
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take effect. This property is not used if the scalable resource is an Auto Scaling group.
         *
         * With the *scale-out cooldown period*, the intention is to continuously (but not excessively) scale out. After Auto Scaling successfully scales out using a target tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't increase the desired capacity again unless either a larger scale out is triggered or the cooldown period ends.
         */
        public var scaleOutCooldown: kotlin.Int? = null
        /**
         * The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.TargetTrackingConfiguration) : this() {
            this.customizedScalingMetricSpecification = x.customizedScalingMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.estimatedInstanceWarmup = x.estimatedInstanceWarmup
            this.predefinedScalingMetricSpecification = x.predefinedScalingMetricSpecification
            this.scaleInCooldown = x.scaleInCooldown
            this.scaleOutCooldown = x.scaleOutCooldown
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.TargetTrackingConfiguration = TargetTrackingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification] inside the given [block]
         */
        public fun customizedScalingMetricSpecification(block: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification.Builder.() -> kotlin.Unit) {
            this.customizedScalingMetricSpecification = aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification] inside the given [block]
         */
        public fun predefinedScalingMetricSpecification(block: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification.Builder.() -> kotlin.Unit) {
            this.predefinedScalingMetricSpecification = aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (targetValue == null) targetValue = 0.0
            return this
        }
    }
}
