// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a scalable resource.
 */
public class ScalingPlanResource private constructor(builder: Builder) {
    /**
     * The ID of the resource. This string consists of the resource type and unique identifier.
     * + Auto Scaling group - The resource type is `autoScalingGroup` and the unique identifier is the name of the Auto Scaling group. Example: `autoScalingGroup/my-asg`.
     * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
     * + Spot Fleet request - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
     * + DynamoDB table - The resource type is `table` and the unique identifier is the resource ID. Example: `table/my-table`.
     * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the resource ID. Example: `table/my-table/index/my-table-index`.
     * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The scalable dimension for the resource.
     * + `autoscaling:autoScalingGroup:DesiredCapacity` - The desired capacity of an Auto Scaling group.
     * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
     * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet request.
     * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
     * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
     * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
     * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
     * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     */
    public val scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension = requireNotNull(builder.scalableDimension) { "A non-null value must be provided for scalableDimension" }
    /**
     * The name of the scaling plan.
     */
    public val scalingPlanName: kotlin.String = requireNotNull(builder.scalingPlanName) { "A non-null value must be provided for scalingPlanName" }
    /**
     * The version number of the scaling plan.
     */
    public val scalingPlanVersion: kotlin.Long = requireNotNull(builder.scalingPlanVersion) { "A non-null value must be provided for scalingPlanVersion" }
    /**
     * The scaling policies.
     */
    public val scalingPolicies: List<ScalingPolicy>? = builder.scalingPolicies
    /**
     * The scaling status of the resource.
     * + `Active` - The scaling configuration is active.
     * + `Inactive` - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.
     * + `PartiallyActive` - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.
     */
    public val scalingStatusCode: aws.sdk.kotlin.services.autoscalingplans.model.ScalingStatusCode = requireNotNull(builder.scalingStatusCode) { "A non-null value must be provided for scalingStatusCode" }
    /**
     * A simple message about the current scaling status of the resource.
     */
    public val scalingStatusMessage: kotlin.String? = builder.scalingStatusMessage
    /**
     * The namespace of the AWS service.
     */
    public val serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace = requireNotNull(builder.serviceNamespace) { "A non-null value must be provided for serviceNamespace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPlanResource(")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("scalingPolicies=$scalingPolicies,")
        append("scalingStatusCode=$scalingStatusCode,")
        append("scalingStatusMessage=$scalingStatusMessage,")
        append("serviceNamespace=$serviceNamespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId.hashCode()
        result = 31 * result + (scalableDimension.hashCode())
        result = 31 * result + (scalingPlanName.hashCode())
        result = 31 * result + (scalingPlanVersion.hashCode())
        result = 31 * result + (scalingPolicies?.hashCode() ?: 0)
        result = 31 * result + (scalingStatusCode.hashCode())
        result = 31 * result + (scalingStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingPlanResource

        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (scalingPolicies != other.scalingPolicies) return false
        if (scalingStatusCode != other.scalingStatusCode) return false
        if (scalingStatusMessage != other.scalingStatusMessage) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the resource. This string consists of the resource type and unique identifier.
         * + Auto Scaling group - The resource type is `autoScalingGroup` and the unique identifier is the name of the Auto Scaling group. Example: `autoScalingGroup/my-asg`.
         * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
         * + Spot Fleet request - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
         * + DynamoDB table - The resource type is `table` and the unique identifier is the resource ID. Example: `table/my-table`.
         * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the resource ID. Example: `table/my-table/index/my-table-index`.
         * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The scalable dimension for the resource.
         * + `autoscaling:autoScalingGroup:DesiredCapacity` - The desired capacity of an Auto Scaling group.
         * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
         * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet request.
         * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
         * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
         * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
         * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
         * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        public var scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension? = null
        /**
         * The name of the scaling plan.
         */
        public var scalingPlanName: kotlin.String? = null
        /**
         * The version number of the scaling plan.
         */
        public var scalingPlanVersion: kotlin.Long? = null
        /**
         * The scaling policies.
         */
        public var scalingPolicies: List<ScalingPolicy>? = null
        /**
         * The scaling status of the resource.
         * + `Active` - The scaling configuration is active.
         * + `Inactive` - The scaling configuration is not active because the scaling plan is being created or the scaling configuration could not be applied. Check the status message for more information.
         * + `PartiallyActive` - The scaling configuration is partially active because the scaling plan is being created or deleted or the scaling configuration could not be fully applied. Check the status message for more information.
         */
        public var scalingStatusCode: aws.sdk.kotlin.services.autoscalingplans.model.ScalingStatusCode? = null
        /**
         * A simple message about the current scaling status of the resource.
         */
        public var scalingStatusMessage: kotlin.String? = null
        /**
         * The namespace of the AWS service.
         */
        public var serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanResource) : this() {
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.scalingPolicies = x.scalingPolicies
            this.scalingStatusCode = x.scalingStatusCode
            this.scalingStatusMessage = x.scalingStatusMessage
            this.serviceNamespace = x.serviceNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanResource = ScalingPlanResource(this)

        internal fun correctErrors(): Builder {
            if (resourceId == null) resourceId = ""
            if (scalableDimension == null) scalableDimension = ScalableDimension.SdkUnknown("no value provided")
            if (scalingPlanName == null) scalingPlanName = ""
            if (scalingPlanVersion == null) scalingPlanVersion = 0L
            if (scalingStatusCode == null) scalingStatusCode = ScalingStatusCode.SdkUnknown("no value provided")
            if (serviceNamespace == null) serviceNamespace = ServiceNamespace.SdkUnknown("no value provided")
            return this
        }
    }
}
