// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a scaling plan.
 */
public class ScalingPlan private constructor(builder: Builder) {
    /**
     * A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
     */
    public val applicationSource: aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource? = builder.applicationSource
    /**
     * The Unix time stamp when the scaling plan was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The scaling instructions.
     */
    public val scalingInstructions: List<ScalingInstruction> = requireNotNull(builder.scalingInstructions) { "A non-null value must be provided for scalingInstructions" }
    /**
     * The name of the scaling plan.
     */
    public val scalingPlanName: kotlin.String = requireNotNull(builder.scalingPlanName) { "A non-null value must be provided for scalingPlanName" }
    /**
     * The version number of the scaling plan.
     */
    public val scalingPlanVersion: kotlin.Long = requireNotNull(builder.scalingPlanVersion) { "A non-null value must be provided for scalingPlanVersion" }
    /**
     * The status of the scaling plan.
     * + `Active` - The scaling plan is active.
     * + `ActiveWithProblems` - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.
     * + `CreationInProgress` - The scaling plan is being created.
     * + `CreationFailed` - The scaling plan could not be created.
     * + `DeletionInProgress` - The scaling plan is being deleted.
     * + `DeletionFailed` - The scaling plan could not be deleted.
     * + `UpdateInProgress` - The scaling plan is being updated.
     * + `UpdateFailed` - The scaling plan could not be updated.
     */
    public val statusCode: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanStatusCode = requireNotNull(builder.statusCode) { "A non-null value must be provided for statusCode" }
    /**
     * A simple message about the current status of the scaling plan.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The Unix time stamp when the scaling plan entered the current status.
     */
    public val statusStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.statusStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPlan(")
        append("applicationSource=$applicationSource,")
        append("creationTime=$creationTime,")
        append("scalingInstructions=$scalingInstructions,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("statusCode=$statusCode,")
        append("statusMessage=$statusMessage,")
        append("statusStartTime=$statusStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSource?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (scalingInstructions.hashCode())
        result = 31 * result + (scalingPlanName.hashCode())
        result = 31 * result + (scalingPlanVersion.hashCode())
        result = 31 * result + (statusCode.hashCode())
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (statusStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingPlan

        if (applicationSource != other.applicationSource) return false
        if (creationTime != other.creationTime) return false
        if (scalingInstructions != other.scalingInstructions) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (statusCode != other.statusCode) return false
        if (statusMessage != other.statusMessage) return false
        if (statusStartTime != other.statusStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlan = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
         */
        public var applicationSource: aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource? = null
        /**
         * The Unix time stamp when the scaling plan was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The scaling instructions.
         */
        public var scalingInstructions: List<ScalingInstruction>? = null
        /**
         * The name of the scaling plan.
         */
        public var scalingPlanName: kotlin.String? = null
        /**
         * The version number of the scaling plan.
         */
        public var scalingPlanVersion: kotlin.Long? = null
        /**
         * The status of the scaling plan.
         * + `Active` - The scaling plan is active.
         * + `ActiveWithProblems` - The scaling plan is active, but the scaling configuration for one or more resources could not be applied.
         * + `CreationInProgress` - The scaling plan is being created.
         * + `CreationFailed` - The scaling plan could not be created.
         * + `DeletionInProgress` - The scaling plan is being deleted.
         * + `DeletionFailed` - The scaling plan could not be deleted.
         * + `UpdateInProgress` - The scaling plan is being updated.
         * + `UpdateFailed` - The scaling plan could not be updated.
         */
        public var statusCode: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanStatusCode? = null
        /**
         * A simple message about the current status of the scaling plan.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The Unix time stamp when the scaling plan entered the current status.
         */
        public var statusStartTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlan) : this() {
            this.applicationSource = x.applicationSource
            this.creationTime = x.creationTime
            this.scalingInstructions = x.scalingInstructions
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.statusCode = x.statusCode
            this.statusMessage = x.statusMessage
            this.statusStartTime = x.statusStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlan = ScalingPlan(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource] inside the given [block]
         */
        public fun applicationSource(block: aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource.Builder.() -> kotlin.Unit) {
            this.applicationSource = aws.sdk.kotlin.services.autoscalingplans.model.ApplicationSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (scalingInstructions == null) scalingInstructions = emptyList()
            if (scalingPlanName == null) scalingPlanName = ""
            if (scalingPlanVersion == null) scalingPlanVersion = 0L
            if (statusCode == null) statusCode = ScalingPlanStatusCode.SdkUnknown("no value provided")
            return this
        }
    }
}
