// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a predefined metric that can be used for predictive scaling.
 *
 * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see [View Scaling Information for a Resource](https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource) in the *AWS Auto Scaling User Guide*.
 */
public class PredefinedLoadMetricSpecification private constructor(builder: Builder) {
    /**
     * The metric type.
     */
    public val predefinedLoadMetricType: aws.sdk.kotlin.services.autoscalingplans.model.LoadMetricType = requireNotNull(builder.predefinedLoadMetricType) { "A non-null value must be provided for predefinedLoadMetricType" }
    /**
     * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is `ALBTargetGroupRequestCount` and there is a target group for an Application Load Balancer attached to the Auto Scaling group.
     *
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
     * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
     * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
     *
     * This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     *
     * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
     */
    public val resourceLabel: kotlin.String? = builder.resourceLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredefinedLoadMetricSpecification(")
        append("predefinedLoadMetricType=$predefinedLoadMetricType,")
        append("resourceLabel=$resourceLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedLoadMetricType.hashCode()
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredefinedLoadMetricSpecification

        if (predefinedLoadMetricType != other.predefinedLoadMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The metric type.
         */
        public var predefinedLoadMetricType: aws.sdk.kotlin.services.autoscalingplans.model.LoadMetricType? = null
        /**
         * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is `ALBTargetGroupRequestCount` and there is a target group for an Application Load Balancer attached to the Auto Scaling group.
         *
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>, where:
         * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
         * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
         *
         * This is an example: app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         *
         * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
         */
        public var resourceLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification) : this() {
            this.predefinedLoadMetricType = x.predefinedLoadMetricType
            this.resourceLabel = x.resourceLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification = PredefinedLoadMetricSpecification(this)

        internal fun correctErrors(): Builder {
            if (predefinedLoadMetricType == null) predefinedLoadMetricType = LoadMetricType.SdkUnknown("no value provided")
            return this
        }
    }
}
