// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeScalingPlansRequest private constructor(builder: Builder) {
    /**
     * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources.
     */
    public val applicationSources: List<ApplicationSource>? = builder.applicationSources
    /**
     * The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names.
     */
    public val scalingPlanNames: List<String>? = builder.scalingPlanNames
    /**
     * The version number of the scaling plan. Currently, the only valid value is `1`.
     *
     * If you specify a scaling plan version, you must also specify a scaling plan name.
     */
    public val scalingPlanVersion: kotlin.Long? = builder.scalingPlanVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.DescribeScalingPlansRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeScalingPlansRequest(")
        append("applicationSources=$applicationSources,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scalingPlanNames=$scalingPlanNames,")
        append("scalingPlanVersion=$scalingPlanVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSources?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanNames?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeScalingPlansRequest

        if (applicationSources != other.applicationSources) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scalingPlanNames != other.scalingPlanNames) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.DescribeScalingPlansRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application sources.
         */
        public var applicationSources: List<ApplicationSource>? = null
        /**
         * The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan names.
         */
        public var scalingPlanNames: List<String>? = null
        /**
         * The version number of the scaling plan. Currently, the only valid value is `1`.
         *
         * If you specify a scaling plan version, you must also specify a scaling plan name.
         */
        public var scalingPlanVersion: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.DescribeScalingPlansRequest) : this() {
            this.applicationSources = x.applicationSources
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scalingPlanNames = x.scalingPlanNames
            this.scalingPlanVersion = x.scalingPlanVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.DescribeScalingPlansRequest = DescribeScalingPlansRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
