// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a CloudWatch metric of your choosing that can be used for dynamic scaling as part of a target tracking scaling policy.
 *
 * To create your customized scaling metric specification:
 * + Add values for each required parameter from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see [Publish Custom Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html) in the *Amazon CloudWatch User Guide*.
 * + Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases.
 *
 * For information about terminology, available metrics, or how to publish new metrics, see [Amazon CloudWatch Concepts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html) in the *Amazon CloudWatch User Guide*.
 */
public class CustomizedScalingMetricSpecification private constructor(builder: Builder) {
    /**
     * The dimensions of the metric.
     *
     * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.
     */
    public val dimensions: List<MetricDimension>? = builder.dimensions
    /**
     * The name of the metric.
     */
    public val metricName: kotlin.String = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }
    /**
     * The namespace of the metric.
     */
    public val namespace: kotlin.String = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * The statistic of the metric.
     */
    public val statistic: aws.sdk.kotlin.services.autoscalingplans.model.MetricStatistic = requireNotNull(builder.statistic) { "A non-null value must be provided for statistic" }
    /**
     * The unit of the metric.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomizedScalingMetricSpecification(")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("statistic=$statistic,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (metricName.hashCode())
        result = 31 * result + (namespace.hashCode())
        result = 31 * result + (statistic.hashCode())
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomizedScalingMetricSpecification

        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (statistic != other.statistic) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The dimensions of the metric.
         *
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized scaling metric specification.
         */
        public var dimensions: List<MetricDimension>? = null
        /**
         * The name of the metric.
         */
        public var metricName: kotlin.String? = null
        /**
         * The namespace of the metric.
         */
        public var namespace: kotlin.String? = null
        /**
         * The statistic of the metric.
         */
        public var statistic: aws.sdk.kotlin.services.autoscalingplans.model.MetricStatistic? = null
        /**
         * The unit of the metric.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification) : this() {
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.statistic = x.statistic
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification = CustomizedScalingMetricSpecification(this)

        internal fun correctErrors(): Builder {
            if (metricName == null) metricName = ""
            if (namespace == null) namespace = ""
            if (statistic == null) statistic = MetricStatistic.SdkUnknown("no value provided")
            return this
        }
    }
}
