// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a CloudWatch metric of your choosing that can be used for predictive scaling.
 *
 * For predictive scaling to work with a customized load metric specification, AWS Auto Scaling needs access to the `Sum` and `Average` statistics that CloudWatch computes from metric data.
 *
 * When you choose a load metric, make sure that the required `Sum` and `Average` statistics for your metric are available in CloudWatch and that they provide relevant data for predictive scaling. The `Sum` statistic must represent the total load on the resource, and the `Average` statistic must represent the average load per capacity unit of the resource. For example, there is a metric that counts the number of requests processed by your Auto Scaling group. If the `Sum` statistic represents the total request count processed by the group, then the `Average` statistic for the specified metric must represent the average request count processed by each instance of the group.
 *
 * If you publish your own metrics, you can aggregate the data points at a given interval and then publish the aggregated data points to CloudWatch. Before AWS Auto Scaling generates the forecast, it sums up all the metric data points that occurred within each hour to match the granularity period that is used in the forecast (60 minutes).
 *
 * For information about terminology, available metrics, or how to publish new metrics, see [Amazon CloudWatch Concepts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html) in the *Amazon CloudWatch User Guide*.
 *
 * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified metric. For more information, see [View Scaling Information for a Resource](https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource) in the *AWS Auto Scaling User Guide*.
 */
public class CustomizedLoadMetricSpecification private constructor(builder: Builder) {
    /**
     * The dimensions of the metric.
     *
     * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.
     */
    public val dimensions: List<MetricDimension>? = builder.dimensions
    /**
     * The name of the metric.
     */
    public val metricName: kotlin.String = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }
    /**
     * The namespace of the metric.
     */
    public val namespace: kotlin.String = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * The statistic of the metric. The only valid value is `Sum`.
     */
    public val statistic: aws.sdk.kotlin.services.autoscalingplans.model.MetricStatistic = requireNotNull(builder.statistic) { "A non-null value must be provided for statistic" }
    /**
     * The unit of the metric.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomizedLoadMetricSpecification(")
        append("dimensions=$dimensions,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("statistic=$statistic,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (metricName.hashCode())
        result = 31 * result + (namespace.hashCode())
        result = 31 * result + (statistic.hashCode())
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomizedLoadMetricSpecification

        if (dimensions != other.dimensions) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (statistic != other.statistic) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The dimensions of the metric.
         *
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your customized load metric specification.
         */
        public var dimensions: List<MetricDimension>? = null
        /**
         * The name of the metric.
         */
        public var metricName: kotlin.String? = null
        /**
         * The namespace of the metric.
         */
        public var namespace: kotlin.String? = null
        /**
         * The statistic of the metric. The only valid value is `Sum`.
         */
        public var statistic: aws.sdk.kotlin.services.autoscalingplans.model.MetricStatistic? = null
        /**
         * The unit of the metric.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification) : this() {
            this.dimensions = x.dimensions
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.statistic = x.statistic
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification = CustomizedLoadMetricSpecification(this)

        internal fun correctErrors(): Builder {
            if (metricName == null) metricName = ""
            if (namespace == null) namespace = ""
            if (statistic == null) statistic = MetricStatistic.SdkUnknown("no value provided")
            return this
        }
    }
}
