// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.serde

import aws.sdk.kotlin.services.autoscalingplans.model.AutoScalingPlansException
import aws.sdk.kotlin.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse
import aws.sdk.kotlin.services.autoscalingplans.model.ScalingPlanResource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeScalingPlanResourcesOperationDeserializer: HttpDeserialize<DescribeScalingPlanResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeScalingPlanResourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeScalingPlanResourcesError(context, call)
        }
        val builder = DescribeScalingPlanResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeScalingPlanResourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeScalingPlanResourcesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AutoScalingPlansException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AutoScalingPlansException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeScalingPlanResourcesOperationBody(builder: DescribeScalingPlanResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SCALINGPLANRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ScalingPlanResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SCALINGPLANRESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SCALINGPLANRESOURCES_DESCRIPTOR.index -> builder.scalingPlanResources =
                    deserializer.deserializeList(SCALINGPLANRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<ScalingPlanResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeScalingPlanResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
