// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Describes a scaling instruction for a scalable resource in a scaling plan. Each scaling instruction applies to one resource.
 *
 * AWS Auto Scaling creates target tracking scaling policies based on the scaling instructions. Target tracking scaling policies adjust the capacity of your scalable resource as required to maintain resource utilization at the target value that you specified.
 *
 * AWS Auto Scaling also configures predictive scaling for your Amazon EC2 Auto Scaling groups using a subset of parameters, including the load metric, the scaling metric, the target value for the scaling metric, the predictive scaling mode (forecast and scale or forecast only), and the desired behavior when the forecast capacity exceeds the maximum capacity of the resource. With predictive scaling, AWS Auto Scaling generates forecasts with traffic predictions for the two days ahead and schedules scaling actions that proactively add and remove resource capacity to match the forecast.
 *
 * We recommend waiting a minimum of 24 hours after creating an Auto Scaling group to configure predictive scaling. At minimum, there must be 24 hours of historical data to generate a forecast. For more information, see [Best Practices for AWS Auto Scaling](https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-best-practices.html) in the *AWS Auto Scaling User Guide*.
 */
public class ScalingInstruction private constructor(builder: Builder) {
    /**
     * The customized load metric to use for predictive scaling. This parameter or a **PredefinedLoadMetricSpecification** is required when configuring predictive scaling, and cannot be used otherwise.
     */
    public val customizedLoadMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification? = builder.customizedLoadMetricSpecification
    /**
     * Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations.
     *
     * The default is enabled (`false`).
     */
    public val disableDynamicScaling: kotlin.Boolean? = builder.disableDynamicScaling
    /**
     * The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for **PredictiveScalingMaxCapacityBehavior**.
     */
    public val maxCapacity: kotlin.Int = requireNotNull(builder.maxCapacity) { "A non-null value must be provided for maxCapacity" }
    /**
     * The minimum capacity of the resource.
     */
    public val minCapacity: kotlin.Int = requireNotNull(builder.minCapacity) { "A non-null value must be provided for minCapacity" }
    /**
     * The predefined load metric to use for predictive scaling. This parameter or a **CustomizedLoadMetricSpecification** is required when configuring predictive scaling, and cannot be used otherwise.
     */
    public val predefinedLoadMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification? = builder.predefinedLoadMetricSpecification
    /**
     * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is `SetForecastCapacityToMaxCapacity`.
     *
     * The following are possible values:
     * + `SetForecastCapacityToMaxCapacity` - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.
     * + `SetMaxCapacityToForecastCapacity` - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.
     * + `SetMaxCapacityAboveForecastCapacity` - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs.
     *
     * Only valid when configuring predictive scaling.
     */
    public val predictiveScalingMaxCapacityBehavior: aws.sdk.kotlin.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior? = builder.predictiveScalingMaxCapacityBehavior
    /**
     * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
     *
     * Only valid when configuring predictive scaling. Required if the **PredictiveScalingMaxCapacityBehavior** is set to `SetMaxCapacityAboveForecastCapacity`, and cannot be used otherwise.
     *
     * The range is 1-100.
     */
    public val predictiveScalingMaxCapacityBuffer: kotlin.Int? = builder.predictiveScalingMaxCapacityBuffer
    /**
     * The predictive scaling mode. The default value is `ForecastAndScale`. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast.
     */
    public val predictiveScalingMode: aws.sdk.kotlin.services.autoscalingplans.model.PredictiveScalingMode? = builder.predictiveScalingMode
    /**
     * The ID of the resource. This string consists of the resource type and unique identifier.
     * + Auto Scaling group - The resource type is `autoScalingGroup` and the unique identifier is the name of the Auto Scaling group. Example: `autoScalingGroup/my-asg`.
     * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
     * + Spot Fleet request - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
     * + DynamoDB table - The resource type is `table` and the unique identifier is the resource ID. Example: `table/my-table`.
     * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the resource ID. Example: `table/my-table/index/my-table-index`.
     * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The scalable dimension associated with the resource.
     * + `autoscaling:autoScalingGroup:DesiredCapacity` - The desired capacity of an Auto Scaling group.
     * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
     * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet request.
     * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
     * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
     * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
     * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
     * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     */
    public val scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension = requireNotNull(builder.scalableDimension) { "A non-null value must be provided for scalableDimension" }
    /**
     * Controls whether a resource's externally created scaling policies are kept or replaced.
     *
     * The default value is `KeepExternalPolicies`. If the parameter is set to `ReplaceExternalPolicies`, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created.
     *
     * Only valid when configuring dynamic scaling.
     *
     * Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.
     */
    public val scalingPolicyUpdateBehavior: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPolicyUpdateBehavior? = builder.scalingPolicyUpdateBehavior
    /**
     * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
     *
     * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds.
     *
     * Only valid when configuring predictive scaling.
     */
    public val scheduledActionBufferTime: kotlin.Int? = builder.scheduledActionBufferTime
    /**
     * The namespace of the AWS service.
     */
    public val serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace = requireNotNull(builder.serviceNamespace) { "A non-null value must be provided for serviceNamespace" }
    /**
     * The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric.
     */
    public val targetTrackingConfigurations: List<TargetTrackingConfiguration> = requireNotNull(builder.targetTrackingConfigurations) { "A non-null value must be provided for targetTrackingConfigurations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.ScalingInstruction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingInstruction(")
        append("customizedLoadMetricSpecification=$customizedLoadMetricSpecification,")
        append("disableDynamicScaling=$disableDynamicScaling,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("predefinedLoadMetricSpecification=$predefinedLoadMetricSpecification,")
        append("predictiveScalingMaxCapacityBehavior=$predictiveScalingMaxCapacityBehavior,")
        append("predictiveScalingMaxCapacityBuffer=$predictiveScalingMaxCapacityBuffer,")
        append("predictiveScalingMode=$predictiveScalingMode,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPolicyUpdateBehavior=$scalingPolicyUpdateBehavior,")
        append("scheduledActionBufferTime=$scheduledActionBufferTime,")
        append("serviceNamespace=$serviceNamespace,")
        append("targetTrackingConfigurations=$targetTrackingConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedLoadMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableDynamicScaling?.hashCode() ?: 0)
        result = 31 * result + (maxCapacity)
        result = 31 * result + (minCapacity)
        result = 31 * result + (predefinedLoadMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingMaxCapacityBehavior?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingMaxCapacityBuffer ?: 0)
        result = 31 * result + (predictiveScalingMode?.hashCode() ?: 0)
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (scalableDimension.hashCode())
        result = 31 * result + (scalingPolicyUpdateBehavior?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionBufferTime ?: 0)
        result = 31 * result + (serviceNamespace.hashCode())
        result = 31 * result + (targetTrackingConfigurations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingInstruction

        if (customizedLoadMetricSpecification != other.customizedLoadMetricSpecification) return false
        if (disableDynamicScaling != other.disableDynamicScaling) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (predefinedLoadMetricSpecification != other.predefinedLoadMetricSpecification) return false
        if (predictiveScalingMaxCapacityBehavior != other.predictiveScalingMaxCapacityBehavior) return false
        if (predictiveScalingMaxCapacityBuffer != other.predictiveScalingMaxCapacityBuffer) return false
        if (predictiveScalingMode != other.predictiveScalingMode) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPolicyUpdateBehavior != other.scalingPolicyUpdateBehavior) return false
        if (scheduledActionBufferTime != other.scheduledActionBufferTime) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (targetTrackingConfigurations != other.targetTrackingConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.ScalingInstruction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The customized load metric to use for predictive scaling. This parameter or a **PredefinedLoadMetricSpecification** is required when configuring predictive scaling, and cannot be used otherwise.
         */
        public var customizedLoadMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification? = null
        /**
         * Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic scaling is enabled, AWS Auto Scaling creates target tracking scaling policies based on the specified target tracking configurations.
         *
         * The default is enabled (`false`).
         */
        public var disableDynamicScaling: kotlin.Boolean? = null
        /**
         * The maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for **PredictiveScalingMaxCapacityBehavior**.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The minimum capacity of the resource.
         */
        public var minCapacity: kotlin.Int? = null
        /**
         * The predefined load metric to use for predictive scaling. This parameter or a **CustomizedLoadMetricSpecification** is required when configuring predictive scaling, and cannot be used otherwise.
         */
        public var predefinedLoadMetricSpecification: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification? = null
        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource. The default value is `SetForecastCapacityToMaxCapacity`.
         *
         * The following are possible values:
         * + `SetForecastCapacityToMaxCapacity` - AWS Auto Scaling cannot scale resource capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.
         * + `SetMaxCapacityToForecastCapacity` - AWS Auto Scaling may scale resource capacity higher than the maximum capacity to equal but not exceed forecast capacity.
         * + `SetMaxCapacityAboveForecastCapacity` - AWS Auto Scaling may scale resource capacity higher than the maximum capacity by a specified buffer value. The intention is to give the target tracking scaling policy extra capacity if unexpected traffic occurs.
         *
         * Only valid when configuring predictive scaling.
         */
        public var predictiveScalingMaxCapacityBehavior: aws.sdk.kotlin.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior? = null
        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
         *
         * Only valid when configuring predictive scaling. Required if the **PredictiveScalingMaxCapacityBehavior** is set to `SetMaxCapacityAboveForecastCapacity`, and cannot be used otherwise.
         *
         * The range is 1-100.
         */
        public var predictiveScalingMaxCapacityBuffer: kotlin.Int? = null
        /**
         * The predictive scaling mode. The default value is `ForecastAndScale`. Otherwise, AWS Auto Scaling forecasts capacity but does not create any scheduled scaling actions based on the capacity forecast.
         */
        public var predictiveScalingMode: aws.sdk.kotlin.services.autoscalingplans.model.PredictiveScalingMode? = null
        /**
         * The ID of the resource. This string consists of the resource type and unique identifier.
         * + Auto Scaling group - The resource type is `autoScalingGroup` and the unique identifier is the name of the Auto Scaling group. Example: `autoScalingGroup/my-asg`.
         * + ECS service - The resource type is `service` and the unique identifier is the cluster name and service name. Example: `service/default/sample-webapp`.
         * + Spot Fleet request - The resource type is `spot-fleet-request` and the unique identifier is the Spot Fleet request ID. Example: `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
         * + DynamoDB table - The resource type is `table` and the unique identifier is the resource ID. Example: `table/my-table`.
         * + DynamoDB global secondary index - The resource type is `index` and the unique identifier is the resource ID. Example: `table/my-table/index/my-table-index`.
         * + Aurora DB cluster - The resource type is `cluster` and the unique identifier is the cluster name. Example: `cluster:my-db-cluster`.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The scalable dimension associated with the resource.
         * + `autoscaling:autoScalingGroup:DesiredCapacity` - The desired capacity of an Auto Scaling group.
         * + `ecs:service:DesiredCount` - The desired task count of an ECS service.
         * + `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a Spot Fleet request.
         * + `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB table.
         * + `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB table.
         * + `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity for a DynamoDB global secondary index.
         * + `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity for a DynamoDB global secondary index.
         * + `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        public var scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension? = null
        /**
         * Controls whether a resource's externally created scaling policies are kept or replaced.
         *
         * The default value is `KeepExternalPolicies`. If the parameter is set to `ReplaceExternalPolicies`, any scaling policies that are external to AWS Auto Scaling are deleted and new target tracking scaling policies created.
         *
         * Only valid when configuring dynamic scaling.
         *
         * Condition: The number of existing policies to be replaced must be less than or equal to 50. If there are more than 50 policies to be replaced, AWS Auto Scaling keeps all existing policies and does not create new ones.
         */
        public var scalingPolicyUpdateBehavior: aws.sdk.kotlin.services.autoscalingplans.model.ScalingPolicyUpdateBehavior? = null
        /**
         * The amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out. For example, if the forecast says to add capacity at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding scheduled scaling action will be 9:55 AM. The intention is to give resources time to be provisioned. For example, it can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
         *
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). The default is 300 seconds.
         *
         * Only valid when configuring predictive scaling.
         */
        public var scheduledActionBufferTime: kotlin.Int? = null
        /**
         * The namespace of the AWS service.
         */
        public var serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace? = null
        /**
         * The target tracking configurations (up to 10). Each of these structures must specify a unique scaling metric and a target value for the metric.
         */
        public var targetTrackingConfigurations: List<TargetTrackingConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.ScalingInstruction) : this() {
            this.customizedLoadMetricSpecification = x.customizedLoadMetricSpecification
            this.disableDynamicScaling = x.disableDynamicScaling
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.predefinedLoadMetricSpecification = x.predefinedLoadMetricSpecification
            this.predictiveScalingMaxCapacityBehavior = x.predictiveScalingMaxCapacityBehavior
            this.predictiveScalingMaxCapacityBuffer = x.predictiveScalingMaxCapacityBuffer
            this.predictiveScalingMode = x.predictiveScalingMode
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPolicyUpdateBehavior = x.scalingPolicyUpdateBehavior
            this.scheduledActionBufferTime = x.scheduledActionBufferTime
            this.serviceNamespace = x.serviceNamespace
            this.targetTrackingConfigurations = x.targetTrackingConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.ScalingInstruction = ScalingInstruction(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification] inside the given [block]
         */
        public fun customizedLoadMetricSpecification(block: aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification.Builder.() -> kotlin.Unit) {
            this.customizedLoadMetricSpecification = aws.sdk.kotlin.services.autoscalingplans.model.CustomizedLoadMetricSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification] inside the given [block]
         */
        public fun predefinedLoadMetricSpecification(block: aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification.Builder.() -> kotlin.Unit) {
            this.predefinedLoadMetricSpecification = aws.sdk.kotlin.services.autoscalingplans.model.PredefinedLoadMetricSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (maxCapacity == null) maxCapacity = 0
            if (minCapacity == null) minCapacity = 0
            if (resourceId == null) resourceId = ""
            if (scalableDimension == null) scalableDimension = ScalableDimension.SdkUnknown("no value provided")
            if (serviceNamespace == null) serviceNamespace = ServiceNamespace.SdkUnknown("no value provided")
            if (targetTrackingConfigurations == null) targetTrackingConfigurations = emptyList()
            return this
        }
    }
}
