// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetScalingPlanResourceForecastDataRequest private constructor(builder: Builder) {
    /**
     * The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days.
     *
     * Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The type of forecast data to get.
     * + `LoadForecast`: The load metric forecast.
     * + `CapacityForecast`: The capacity forecast.
     * + `ScheduledActionMinCapacity`: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.
     * + `ScheduledActionMaxCapacity`: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.
     */
    public val forecastDataType: aws.sdk.kotlin.services.autoscalingplans.model.ForecastDataType? = builder.forecastDataType
    /**
     * The ID of the resource. This string consists of a prefix (`autoScalingGroup`) followed by the name of a specified Auto Scaling group (`my-asg`). Example: `autoScalingGroup/my-asg`.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The scalable dimension for the resource. The only valid value is `autoscaling:autoScalingGroup:DesiredCapacity`.
     */
    public val scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension? = builder.scalableDimension
    /**
     * The name of the scaling plan.
     */
    public val scalingPlanName: kotlin.String? = builder.scalingPlanName
    /**
     * The version number of the scaling plan. Currently, the only valid value is `1`.
     */
    public val scalingPlanVersion: kotlin.Long? = builder.scalingPlanVersion
    /**
     * The namespace of the AWS service. The only valid value is `autoscaling`.
     */
    public val serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace? = builder.serviceNamespace
    /**
     * The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetScalingPlanResourceForecastDataRequest(")
        append("endTime=$endTime,")
        append("forecastDataType=$forecastDataType,")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("serviceNamespace=$serviceNamespace,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (forecastDataType?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanName?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetScalingPlanResourceForecastDataRequest

        if (endTime != other.endTime) return false
        if (forecastDataType != other.forecastDataType) return false
        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (serviceNamespace != other.serviceNamespace) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is seven days.
         *
         * Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of forecast data to get.
         * + `LoadForecast`: The load metric forecast.
         * + `CapacityForecast`: The capacity forecast.
         * + `ScheduledActionMinCapacity`: The minimum capacity for each scheduled scaling action. This data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.
         * + `ScheduledActionMaxCapacity`: The maximum capacity for each scheduled scaling action. The calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.
         */
        public var forecastDataType: aws.sdk.kotlin.services.autoscalingplans.model.ForecastDataType? = null
        /**
         * The ID of the resource. This string consists of a prefix (`autoScalingGroup`) followed by the name of a specified Auto Scaling group (`my-asg`). Example: `autoScalingGroup/my-asg`.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The scalable dimension for the resource. The only valid value is `autoscaling:autoScalingGroup:DesiredCapacity`.
         */
        public var scalableDimension: aws.sdk.kotlin.services.autoscalingplans.model.ScalableDimension? = null
        /**
         * The name of the scaling plan.
         */
        public var scalingPlanName: kotlin.String? = null
        /**
         * The version number of the scaling plan. Currently, the only valid value is `1`.
         */
        public var scalingPlanVersion: kotlin.Long? = null
        /**
         * The namespace of the AWS service. The only valid value is `autoscaling`.
         */
        public var serviceNamespace: aws.sdk.kotlin.services.autoscalingplans.model.ServiceNamespace? = null
        /**
         * The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days before the current date and time.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest) : this() {
            this.endTime = x.endTime
            this.forecastDataType = x.forecastDataType
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.serviceNamespace = x.serviceNamespace
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest = GetScalingPlanResourceForecastDataRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
