// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration
import aws.sdk.kotlin.services.autoscaling.model.WarmPoolState
import aws.sdk.kotlin.services.autoscaling.model.WarmPoolStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeWarmPoolConfigurationDocument(reader: XmlTagReader): WarmPoolConfiguration {
    val builder = WarmPoolConfiguration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // MaxGroupPreparedCapacity com.amazonaws.autoscaling#WarmPoolConfiguration$MaxGroupPreparedCapacity
            "MaxGroupPreparedCapacity" -> builder.maxGroupPreparedCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#MaxGroupPreparedCapacity`)" }
            // MinSize com.amazonaws.autoscaling#WarmPoolConfiguration$MinSize
            "MinSize" -> builder.minSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#WarmPoolMinSize`)" }
            // PoolState com.amazonaws.autoscaling#WarmPoolConfiguration$PoolState
            "PoolState" -> builder.poolState = curr.tryData()
                .parse { WarmPoolState.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#WarmPoolState`)" }
            // Status com.amazonaws.autoscaling#WarmPoolConfiguration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { WarmPoolStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#WarmPoolStatus`)" }
            // InstanceReusePolicy com.amazonaws.autoscaling#WarmPoolConfiguration$InstanceReusePolicy
            "InstanceReusePolicy" -> builder.instanceReusePolicy = deserializeInstanceReusePolicyDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
