// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeScheduledUpdateGroupActionDocument(reader: XmlTagReader): ScheduledUpdateGroupAction {
    val builder = ScheduledUpdateGroupAction.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AutoScalingGroupName com.amazonaws.autoscaling#ScheduledUpdateGroupAction$AutoScalingGroupName
            "AutoScalingGroupName" -> builder.autoScalingGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // ScheduledActionName com.amazonaws.autoscaling#ScheduledUpdateGroupAction$ScheduledActionName
            "ScheduledActionName" -> builder.scheduledActionName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // ScheduledActionARN com.amazonaws.autoscaling#ScheduledUpdateGroupAction$ScheduledActionARN
            "ScheduledActionARN" -> builder.scheduledActionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            // Time com.amazonaws.autoscaling#ScheduledUpdateGroupAction$Time
            "Time" -> builder.time = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // StartTime com.amazonaws.autoscaling#ScheduledUpdateGroupAction$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // EndTime com.amazonaws.autoscaling#ScheduledUpdateGroupAction$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // Recurrence com.amazonaws.autoscaling#ScheduledUpdateGroupAction$Recurrence
            "Recurrence" -> builder.recurrence = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // MinSize com.amazonaws.autoscaling#ScheduledUpdateGroupAction$MinSize
            "MinSize" -> builder.minSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupMinSize`)" }
            // MaxSize com.amazonaws.autoscaling#ScheduledUpdateGroupAction$MaxSize
            "MaxSize" -> builder.maxSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupMaxSize`)" }
            // DesiredCapacity com.amazonaws.autoscaling#ScheduledUpdateGroupAction$DesiredCapacity
            "DesiredCapacity" -> builder.desiredCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupDesiredCapacity`)" }
            // TimeZone com.amazonaws.autoscaling#ScheduledUpdateGroupAction$TimeZone
            "TimeZone" -> builder.timeZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
