// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.Alarm
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PutScalingPolicyOperationDeserializer: HttpDeserializer.NonStreaming<PutScalingPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutScalingPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutScalingPolicyError(context, call, payload)
        }
        val builder = PutScalingPolicyResponse.Builder()

        if (payload != null) {
            deserializePutScalingPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutScalingPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceLinkedRoleFailure" -> ServiceLinkedRoleFailureDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceeded" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutScalingPolicyOperationBody(builder: PutScalingPolicyResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PutScalingPolicy")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Alarms com.amazonaws.autoscaling#PolicyARNType$Alarms
            "Alarms" -> builder.alarms = deserializeAlarmsShape(curr)
            // PolicyARN com.amazonaws.autoscaling#PolicyARNType$PolicyARN
            "PolicyARN" -> builder.policyArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            else -> {}
        }
        curr.drop()
    }
}
