// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeLaunchConfigurationDocument(reader: XmlTagReader): LaunchConfiguration {
    val builder = LaunchConfiguration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // LaunchConfigurationName com.amazonaws.autoscaling#LaunchConfiguration$LaunchConfigurationName
            "LaunchConfigurationName" -> builder.launchConfigurationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // LaunchConfigurationARN com.amazonaws.autoscaling#LaunchConfiguration$LaunchConfigurationARN
            "LaunchConfigurationARN" -> builder.launchConfigurationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            // ImageId com.amazonaws.autoscaling#LaunchConfiguration$ImageId
            "ImageId" -> builder.imageId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // KeyName com.amazonaws.autoscaling#LaunchConfiguration$KeyName
            "KeyName" -> builder.keyName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // SecurityGroups com.amazonaws.autoscaling#LaunchConfiguration$SecurityGroups
            "SecurityGroups" -> builder.securityGroups = deserializeSecurityGroupsShape(curr)
            // ClassicLinkVPCId com.amazonaws.autoscaling#LaunchConfiguration$ClassicLinkVPCId
            "ClassicLinkVPCId" -> builder.classicLinkVpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // ClassicLinkVPCSecurityGroups com.amazonaws.autoscaling#LaunchConfiguration$ClassicLinkVPCSecurityGroups
            "ClassicLinkVPCSecurityGroups" -> builder.classicLinkVpcSecurityGroups = deserializeClassicLinkVPCSecurityGroupsShape(curr)
            // UserData com.amazonaws.autoscaling#LaunchConfiguration$UserData
            "UserData" -> builder.userData = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringUserData`)" }
            // InstanceType com.amazonaws.autoscaling#LaunchConfiguration$InstanceType
            "InstanceType" -> builder.instanceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // KernelId com.amazonaws.autoscaling#LaunchConfiguration$KernelId
            "KernelId" -> builder.kernelId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // RamdiskId com.amazonaws.autoscaling#LaunchConfiguration$RamdiskId
            "RamdiskId" -> builder.ramdiskId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // BlockDeviceMappings com.amazonaws.autoscaling#LaunchConfiguration$BlockDeviceMappings
            "BlockDeviceMappings" -> builder.blockDeviceMappings = deserializeBlockDeviceMappingsShape(curr)
            // InstanceMonitoring com.amazonaws.autoscaling#LaunchConfiguration$InstanceMonitoring
            "InstanceMonitoring" -> builder.instanceMonitoring = deserializeInstanceMonitoringDocument(curr)
            // SpotPrice com.amazonaws.autoscaling#LaunchConfiguration$SpotPrice
            "SpotPrice" -> builder.spotPrice = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#SpotPrice`)" }
            // IamInstanceProfile com.amazonaws.autoscaling#LaunchConfiguration$IamInstanceProfile
            "IamInstanceProfile" -> builder.iamInstanceProfile = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen1600`)" }
            // CreatedTime com.amazonaws.autoscaling#LaunchConfiguration$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // EbsOptimized com.amazonaws.autoscaling#LaunchConfiguration$EbsOptimized
            "EbsOptimized" -> builder.ebsOptimized = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.autoscaling#EbsOptimized`)" }
            // AssociatePublicIpAddress com.amazonaws.autoscaling#LaunchConfiguration$AssociatePublicIpAddress
            "AssociatePublicIpAddress" -> builder.associatePublicIpAddress = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.autoscaling#AssociatePublicIpAddress`)" }
            // PlacementTenancy com.amazonaws.autoscaling#LaunchConfiguration$PlacementTenancy
            "PlacementTenancy" -> builder.placementTenancy = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen64`)" }
            // MetadataOptions com.amazonaws.autoscaling#LaunchConfiguration$MetadataOptions
            "MetadataOptions" -> builder.metadataOptions = deserializeInstanceMetadataOptionsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
