// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.BareMetal
import aws.sdk.kotlin.services.autoscaling.model.BurstablePerformance
import aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements
import aws.sdk.kotlin.services.autoscaling.model.LocalStorage
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeInstanceRequirementsDocument(reader: XmlTagReader): InstanceRequirements {
    val builder = InstanceRequirements.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // VCpuCount com.amazonaws.autoscaling#InstanceRequirements$VCpuCount
            "VCpuCount" -> builder.vCpuCount = deserializeVCpuCountRequestDocument(curr)
            // MemoryMiB com.amazonaws.autoscaling#InstanceRequirements$MemoryMiB
            "MemoryMiB" -> builder.memoryMib = deserializeMemoryMibRequestDocument(curr)
            // CpuManufacturers com.amazonaws.autoscaling#InstanceRequirements$CpuManufacturers
            "CpuManufacturers" -> builder.cpuManufacturers = deserializeCpuManufacturersShape(curr)
            // MemoryGiBPerVCpu com.amazonaws.autoscaling#InstanceRequirements$MemoryGiBPerVCpu
            "MemoryGiBPerVCpu" -> builder.memoryGibPerVCpu = deserializeMemoryGibPerVCpuRequestDocument(curr)
            // ExcludedInstanceTypes com.amazonaws.autoscaling#InstanceRequirements$ExcludedInstanceTypes
            "ExcludedInstanceTypes" -> builder.excludedInstanceTypes = deserializeExcludedInstanceTypesShape(curr)
            // InstanceGenerations com.amazonaws.autoscaling#InstanceRequirements$InstanceGenerations
            "InstanceGenerations" -> builder.instanceGenerations = deserializeInstanceGenerationsShape(curr)
            // SpotMaxPricePercentageOverLowestPrice com.amazonaws.autoscaling#InstanceRequirements$SpotMaxPricePercentageOverLowestPrice
            "SpotMaxPricePercentageOverLowestPrice" -> builder.spotMaxPricePercentageOverLowestPrice = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#NullablePositiveInteger`)" }
            // MaxSpotPriceAsPercentageOfOptimalOnDemandPrice com.amazonaws.autoscaling#InstanceRequirements$MaxSpotPriceAsPercentageOfOptimalOnDemandPrice
            "MaxSpotPriceAsPercentageOfOptimalOnDemandPrice" -> builder.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#NullablePositiveInteger`)" }
            // OnDemandMaxPricePercentageOverLowestPrice com.amazonaws.autoscaling#InstanceRequirements$OnDemandMaxPricePercentageOverLowestPrice
            "OnDemandMaxPricePercentageOverLowestPrice" -> builder.onDemandMaxPricePercentageOverLowestPrice = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#NullablePositiveInteger`)" }
            // BareMetal com.amazonaws.autoscaling#InstanceRequirements$BareMetal
            "BareMetal" -> builder.bareMetal = curr.tryData()
                .parse { BareMetal.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#BareMetal`)" }
            // BurstablePerformance com.amazonaws.autoscaling#InstanceRequirements$BurstablePerformance
            "BurstablePerformance" -> builder.burstablePerformance = curr.tryData()
                .parse { BurstablePerformance.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#BurstablePerformance`)" }
            // RequireHibernateSupport com.amazonaws.autoscaling#InstanceRequirements$RequireHibernateSupport
            "RequireHibernateSupport" -> builder.requireHibernateSupport = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.autoscaling#NullableBoolean`)" }
            // NetworkInterfaceCount com.amazonaws.autoscaling#InstanceRequirements$NetworkInterfaceCount
            "NetworkInterfaceCount" -> builder.networkInterfaceCount = deserializeNetworkInterfaceCountRequestDocument(curr)
            // LocalStorage com.amazonaws.autoscaling#InstanceRequirements$LocalStorage
            "LocalStorage" -> builder.localStorage = curr.tryData()
                .parse { LocalStorage.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#LocalStorage`)" }
            // LocalStorageTypes com.amazonaws.autoscaling#InstanceRequirements$LocalStorageTypes
            "LocalStorageTypes" -> builder.localStorageTypes = deserializeLocalStorageTypesShape(curr)
            // TotalLocalStorageGB com.amazonaws.autoscaling#InstanceRequirements$TotalLocalStorageGB
            "TotalLocalStorageGB" -> builder.totalLocalStorageGb = deserializeTotalLocalStorageGbRequestDocument(curr)
            // BaselineEbsBandwidthMbps com.amazonaws.autoscaling#InstanceRequirements$BaselineEbsBandwidthMbps
            "BaselineEbsBandwidthMbps" -> builder.baselineEbsBandwidthMbps = deserializeBaselineEbsBandwidthMbpsRequestDocument(curr)
            // AcceleratorTypes com.amazonaws.autoscaling#InstanceRequirements$AcceleratorTypes
            "AcceleratorTypes" -> builder.acceleratorTypes = deserializeAcceleratorTypesShape(curr)
            // AcceleratorCount com.amazonaws.autoscaling#InstanceRequirements$AcceleratorCount
            "AcceleratorCount" -> builder.acceleratorCount = deserializeAcceleratorCountRequestDocument(curr)
            // AcceleratorManufacturers com.amazonaws.autoscaling#InstanceRequirements$AcceleratorManufacturers
            "AcceleratorManufacturers" -> builder.acceleratorManufacturers = deserializeAcceleratorManufacturersShape(curr)
            // AcceleratorNames com.amazonaws.autoscaling#InstanceRequirements$AcceleratorNames
            "AcceleratorNames" -> builder.acceleratorNames = deserializeAcceleratorNamesShape(curr)
            // AcceleratorTotalMemoryMiB com.amazonaws.autoscaling#InstanceRequirements$AcceleratorTotalMemoryMiB
            "AcceleratorTotalMemoryMiB" -> builder.acceleratorTotalMemoryMib = deserializeAcceleratorTotalMemoryMibRequestDocument(curr)
            // NetworkBandwidthGbps com.amazonaws.autoscaling#InstanceRequirements$NetworkBandwidthGbps
            "NetworkBandwidthGbps" -> builder.networkBandwidthGbps = deserializeNetworkBandwidthGbpsRequestDocument(curr)
            // AllowedInstanceTypes com.amazonaws.autoscaling#InstanceRequirements$AllowedInstanceTypes
            "AllowedInstanceTypes" -> builder.allowedInstanceTypes = deserializeAllowedInstanceTypesShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
