// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.InstanceRefresh
import aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeInstanceRefreshDocument(reader: XmlTagReader): InstanceRefresh {
    val builder = InstanceRefresh.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // InstanceRefreshId com.amazonaws.autoscaling#InstanceRefresh$InstanceRefreshId
            "InstanceRefreshId" -> builder.instanceRefreshId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // AutoScalingGroupName com.amazonaws.autoscaling#InstanceRefresh$AutoScalingGroupName
            "AutoScalingGroupName" -> builder.autoScalingGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // Status com.amazonaws.autoscaling#InstanceRefresh$Status
            "Status" -> builder.status = curr.tryData()
                .parse { InstanceRefreshStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#InstanceRefreshStatus`)" }
            // StatusReason com.amazonaws.autoscaling#InstanceRefresh$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen1023`)" }
            // StartTime com.amazonaws.autoscaling#InstanceRefresh$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // EndTime com.amazonaws.autoscaling#InstanceRefresh$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // PercentageComplete com.amazonaws.autoscaling#InstanceRefresh$PercentageComplete
            "PercentageComplete" -> builder.percentageComplete = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#IntPercent`)" }
            // InstancesToUpdate com.amazonaws.autoscaling#InstanceRefresh$InstancesToUpdate
            "InstancesToUpdate" -> builder.instancesToUpdate = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#InstancesToUpdate`)" }
            // ProgressDetails com.amazonaws.autoscaling#InstanceRefresh$ProgressDetails
            "ProgressDetails" -> builder.progressDetails = deserializeInstanceRefreshProgressDetailsDocument(curr)
            // Preferences com.amazonaws.autoscaling#InstanceRefresh$Preferences
            "Preferences" -> builder.preferences = deserializeRefreshPreferencesDocument(curr)
            // DesiredConfiguration com.amazonaws.autoscaling#InstanceRefresh$DesiredConfiguration
            "DesiredConfiguration" -> builder.desiredConfiguration = deserializeDesiredConfigurationDocument(curr)
            // RollbackDetails com.amazonaws.autoscaling#InstanceRefresh$RollbackDetails
            "RollbackDetails" -> builder.rollbackDetails = deserializeRollbackDetailsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
