// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.CapacityForecast
import aws.sdk.kotlin.services.autoscaling.model.GetPredictiveScalingForecastResponse
import aws.sdk.kotlin.services.autoscaling.model.LoadForecast
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetPredictiveScalingForecastOperationDeserializer: HttpDeserializer.NonStreaming<GetPredictiveScalingForecastResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPredictiveScalingForecastResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPredictiveScalingForecastError(context, call, payload)
        }
        val builder = GetPredictiveScalingForecastResponse.Builder()

        if (payload != null) {
            deserializeGetPredictiveScalingForecastOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPredictiveScalingForecastError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPredictiveScalingForecastOperationBody(builder: GetPredictiveScalingForecastResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "GetPredictiveScalingForecast")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CapacityForecast com.amazonaws.autoscaling#GetPredictiveScalingForecastAnswer$CapacityForecast
            "CapacityForecast" -> builder.capacityForecast = deserializeCapacityForecastDocument(curr)
            // LoadForecast com.amazonaws.autoscaling#GetPredictiveScalingForecastAnswer$LoadForecast
            "LoadForecast" -> builder.loadForecast = deserializeLoadForecastsShape(curr)
            // UpdateTime com.amazonaws.autoscaling#GetPredictiveScalingForecastAnswer$UpdateTime
            "UpdateTime" -> builder.updateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            else -> {}
        }
        curr.drop()
    }
}
