// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.DescribeWarmPoolResponse
import aws.sdk.kotlin.services.autoscaling.model.Instance
import aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeWarmPoolOperationDeserializer: HttpDeserializer.NonStreaming<DescribeWarmPoolResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeWarmPoolResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeWarmPoolError(context, call, payload)
        }
        val builder = DescribeWarmPoolResponse.Builder()

        if (payload != null) {
            deserializeDescribeWarmPoolOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeWarmPoolError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceeded" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWarmPoolOperationBody(builder: DescribeWarmPoolResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeWarmPool")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Instances com.amazonaws.autoscaling#DescribeWarmPoolAnswer$Instances
            "Instances" -> builder.instances = deserializeInstancesShape(curr)
            // NextToken com.amazonaws.autoscaling#DescribeWarmPoolAnswer$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlString`)" }
            // WarmPoolConfiguration com.amazonaws.autoscaling#DescribeWarmPoolAnswer$WarmPoolConfiguration
            "WarmPoolConfiguration" -> builder.warmPoolConfiguration = deserializeWarmPoolConfigurationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
