// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.DescribeAccountLimitsResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeAccountLimitsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAccountLimitsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAccountLimitsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAccountLimitsError(context, call, payload)
        }
        val builder = DescribeAccountLimitsResponse.Builder()

        if (payload != null) {
            deserializeDescribeAccountLimitsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAccountLimitsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountLimitsOperationBody(builder: DescribeAccountLimitsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeAccountLimits")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // MaxNumberOfAutoScalingGroups com.amazonaws.autoscaling#DescribeAccountLimitsAnswer$MaxNumberOfAutoScalingGroups
            "MaxNumberOfAutoScalingGroups" -> builder.maxNumberOfAutoScalingGroups = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#MaxNumberOfAutoScalingGroups`)" }
            // MaxNumberOfLaunchConfigurations com.amazonaws.autoscaling#DescribeAccountLimitsAnswer$MaxNumberOfLaunchConfigurations
            "MaxNumberOfLaunchConfigurations" -> builder.maxNumberOfLaunchConfigurations = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#MaxNumberOfLaunchConfigurations`)" }
            // NumberOfAutoScalingGroups com.amazonaws.autoscaling#DescribeAccountLimitsAnswer$NumberOfAutoScalingGroups
            "NumberOfAutoScalingGroups" -> builder.numberOfAutoScalingGroups = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#NumberOfAutoScalingGroups`)" }
            // NumberOfLaunchConfigurations com.amazonaws.autoscaling#DescribeAccountLimitsAnswer$NumberOfLaunchConfigurations
            "NumberOfLaunchConfigurations" -> builder.numberOfLaunchConfigurations = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#NumberOfLaunchConfigurations`)" }
            else -> {}
        }
        curr.drop()
    }
}
