// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.CancelInstanceRefreshResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CancelInstanceRefreshOperationDeserializer: HttpDeserializer.NonStreaming<CancelInstanceRefreshResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CancelInstanceRefreshResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelInstanceRefreshError(context, call, payload)
        }
        val builder = CancelInstanceRefreshResponse.Builder()

        if (payload != null) {
            deserializeCancelInstanceRefreshOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCancelInstanceRefreshError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceeded" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ActiveInstanceRefreshNotFound" -> ActiveInstanceRefreshNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCancelInstanceRefreshOperationBody(builder: CancelInstanceRefreshResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CancelInstanceRefresh")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // InstanceRefreshId com.amazonaws.autoscaling#CancelInstanceRefreshAnswer$InstanceRefreshId
            "InstanceRefreshId" -> builder.instanceRefreshId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            else -> {}
        }
        curr.drop()
    }
}
