// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.BatchDeleteScheduledActionResponse
import aws.sdk.kotlin.services.autoscaling.model.FailedScheduledUpdateGroupActionRequest
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class BatchDeleteScheduledActionOperationDeserializer: HttpDeserializer.NonStreaming<BatchDeleteScheduledActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchDeleteScheduledActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDeleteScheduledActionError(context, call, payload)
        }
        val builder = BatchDeleteScheduledActionResponse.Builder()

        if (payload != null) {
            deserializeBatchDeleteScheduledActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchDeleteScheduledActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDeleteScheduledActionOperationBody(builder: BatchDeleteScheduledActionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BatchDeleteScheduledAction")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // FailedScheduledActions com.amazonaws.autoscaling#BatchDeleteScheduledActionAnswer$FailedScheduledActions
            "FailedScheduledActions" -> builder.failedScheduledActions = deserializeFailedScheduledUpdateGroupActionRequestsShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
