// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeAutoScalingGroupDocument(reader: XmlTagReader): AutoScalingGroup {
    val builder = AutoScalingGroup.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AutoScalingGroupName com.amazonaws.autoscaling#AutoScalingGroup$AutoScalingGroupName
            "AutoScalingGroupName" -> builder.autoScalingGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // AutoScalingGroupARN com.amazonaws.autoscaling#AutoScalingGroup$AutoScalingGroupARN
            "AutoScalingGroupARN" -> builder.autoScalingGroupArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            // LaunchConfigurationName com.amazonaws.autoscaling#AutoScalingGroup$LaunchConfigurationName
            "LaunchConfigurationName" -> builder.launchConfigurationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // LaunchTemplate com.amazonaws.autoscaling#AutoScalingGroup$LaunchTemplate
            "LaunchTemplate" -> builder.launchTemplate = deserializeLaunchTemplateSpecificationDocument(curr)
            // MixedInstancesPolicy com.amazonaws.autoscaling#AutoScalingGroup$MixedInstancesPolicy
            "MixedInstancesPolicy" -> builder.mixedInstancesPolicy = deserializeMixedInstancesPolicyDocument(curr)
            // MinSize com.amazonaws.autoscaling#AutoScalingGroup$MinSize
            "MinSize" -> builder.minSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupMinSize`)" }
            // MaxSize com.amazonaws.autoscaling#AutoScalingGroup$MaxSize
            "MaxSize" -> builder.maxSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupMaxSize`)" }
            // DesiredCapacity com.amazonaws.autoscaling#AutoScalingGroup$DesiredCapacity
            "DesiredCapacity" -> builder.desiredCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupDesiredCapacity`)" }
            // PredictedCapacity com.amazonaws.autoscaling#AutoScalingGroup$PredictedCapacity
            "PredictedCapacity" -> builder.predictedCapacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#AutoScalingGroupPredictedCapacity`)" }
            // DefaultCooldown com.amazonaws.autoscaling#AutoScalingGroup$DefaultCooldown
            "DefaultCooldown" -> builder.defaultCooldown = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#Cooldown`)" }
            // AvailabilityZones com.amazonaws.autoscaling#AutoScalingGroup$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // LoadBalancerNames com.amazonaws.autoscaling#AutoScalingGroup$LoadBalancerNames
            "LoadBalancerNames" -> builder.loadBalancerNames = deserializeLoadBalancerNamesShape(curr)
            // TargetGroupARNs com.amazonaws.autoscaling#AutoScalingGroup$TargetGroupARNs
            "TargetGroupARNs" -> builder.targetGroupArns = deserializeTargetGroupARNsShape(curr)
            // HealthCheckType com.amazonaws.autoscaling#AutoScalingGroup$HealthCheckType
            "HealthCheckType" -> builder.healthCheckType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen32`)" }
            // HealthCheckGracePeriod com.amazonaws.autoscaling#AutoScalingGroup$HealthCheckGracePeriod
            "HealthCheckGracePeriod" -> builder.healthCheckGracePeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#HealthCheckGracePeriod`)" }
            // Instances com.amazonaws.autoscaling#AutoScalingGroup$Instances
            "Instances" -> builder.instances = deserializeInstancesShape(curr)
            // CreatedTime com.amazonaws.autoscaling#AutoScalingGroup$CreatedTime
            "CreatedTime" -> builder.createdTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // SuspendedProcesses com.amazonaws.autoscaling#AutoScalingGroup$SuspendedProcesses
            "SuspendedProcesses" -> builder.suspendedProcesses = deserializeSuspendedProcessesShape(curr)
            // PlacementGroup com.amazonaws.autoscaling#AutoScalingGroup$PlacementGroup
            "PlacementGroup" -> builder.placementGroup = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // VPCZoneIdentifier com.amazonaws.autoscaling#AutoScalingGroup$VPCZoneIdentifier
            "VPCZoneIdentifier" -> builder.vpcZoneIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen2047`)" }
            // EnabledMetrics com.amazonaws.autoscaling#AutoScalingGroup$EnabledMetrics
            "EnabledMetrics" -> builder.enabledMetrics = deserializeEnabledMetricsShape(curr)
            // Status com.amazonaws.autoscaling#AutoScalingGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // Tags com.amazonaws.autoscaling#AutoScalingGroup$Tags
            "Tags" -> builder.tags = deserializeTagDescriptionListShape(curr)
            // TerminationPolicies com.amazonaws.autoscaling#AutoScalingGroup$TerminationPolicies
            "TerminationPolicies" -> builder.terminationPolicies = deserializeTerminationPoliciesShape(curr)
            // NewInstancesProtectedFromScaleIn com.amazonaws.autoscaling#AutoScalingGroup$NewInstancesProtectedFromScaleIn
            "NewInstancesProtectedFromScaleIn" -> builder.newInstancesProtectedFromScaleIn = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.autoscaling#InstanceProtected`)" }
            // ServiceLinkedRoleARN com.amazonaws.autoscaling#AutoScalingGroup$ServiceLinkedRoleARN
            "ServiceLinkedRoleARN" -> builder.serviceLinkedRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            // MaxInstanceLifetime com.amazonaws.autoscaling#AutoScalingGroup$MaxInstanceLifetime
            "MaxInstanceLifetime" -> builder.maxInstanceLifetime = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#MaxInstanceLifetime`)" }
            // CapacityRebalance com.amazonaws.autoscaling#AutoScalingGroup$CapacityRebalance
            "CapacityRebalance" -> builder.capacityRebalance = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.autoscaling#CapacityRebalanceEnabled`)" }
            // WarmPoolConfiguration com.amazonaws.autoscaling#AutoScalingGroup$WarmPoolConfiguration
            "WarmPoolConfiguration" -> builder.warmPoolConfiguration = deserializeWarmPoolConfigurationDocument(curr)
            // WarmPoolSize com.amazonaws.autoscaling#AutoScalingGroup$WarmPoolSize
            "WarmPoolSize" -> builder.warmPoolSize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#WarmPoolSize`)" }
            // Context com.amazonaws.autoscaling#AutoScalingGroup$Context
            "Context" -> builder.context = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#Context`)" }
            // DesiredCapacityType com.amazonaws.autoscaling#AutoScalingGroup$DesiredCapacityType
            "DesiredCapacityType" -> builder.desiredCapacityType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // DefaultInstanceWarmup com.amazonaws.autoscaling#AutoScalingGroup$DefaultInstanceWarmup
            "DefaultInstanceWarmup" -> builder.defaultInstanceWarmup = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#DefaultInstanceWarmup`)" }
            // TrafficSources com.amazonaws.autoscaling#AutoScalingGroup$TrafficSources
            "TrafficSources" -> builder.trafficSources = deserializeTrafficSourcesShape(curr)
            // InstanceMaintenancePolicy com.amazonaws.autoscaling#AutoScalingGroup$InstanceMaintenancePolicy
            "InstanceMaintenancePolicy" -> builder.instanceMaintenancePolicy = deserializeInstanceMaintenancePolicyDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
