// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.Activity
import aws.sdk.kotlin.services.autoscaling.model.ScalingActivityStatusCode
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeActivityDocument(reader: XmlTagReader): Activity {
    val builder = Activity.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ActivityId com.amazonaws.autoscaling#Activity$ActivityId
            "ActivityId" -> builder.activityId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlString`)" }
            // AutoScalingGroupName com.amazonaws.autoscaling#Activity$AutoScalingGroupName
            "AutoScalingGroupName" -> builder.autoScalingGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // Description com.amazonaws.autoscaling#Activity$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlString`)" }
            // Cause com.amazonaws.autoscaling#Activity$Cause
            "Cause" -> builder.cause = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen1023`)" }
            // StartTime com.amazonaws.autoscaling#Activity$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // EndTime com.amazonaws.autoscaling#Activity$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.autoscaling#TimestampType`)" }
            // StatusCode com.amazonaws.autoscaling#Activity$StatusCode
            "StatusCode" -> builder.statusCode = curr.tryData()
                .parse { ScalingActivityStatusCode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.autoscaling#ScalingActivityStatusCode`)" }
            // StatusMessage com.amazonaws.autoscaling#Activity$StatusMessage
            "StatusMessage" -> builder.statusMessage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlStringMaxLen255`)" }
            // Progress com.amazonaws.autoscaling#Activity$Progress
            "Progress" -> builder.progress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.autoscaling#Progress`)" }
            // Details com.amazonaws.autoscaling#Activity$Details
            "Details" -> builder.details = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#XmlString`)" }
            // AutoScalingGroupState com.amazonaws.autoscaling#Activity$AutoScalingGroupState
            "AutoScalingGroupState" -> builder.autoScalingGroupState = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#AutoScalingGroupState`)" }
            // AutoScalingGroupARN com.amazonaws.autoscaling#Activity$AutoScalingGroupARN
            "AutoScalingGroupARN" -> builder.autoScalingGroupArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.autoscaling#ResourceName`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
