// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SetInstanceHealthRequest private constructor(builder: Builder) {
    /**
     * The health status of the instance. Set to `Healthy` to have the instance remain in service. Set to `Unhealthy` to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.
     */
    public val healthStatus: kotlin.String? = builder.healthStatus
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * If the Auto Scaling group of the specified instance has a `HealthCheckGracePeriod` specified for the group, by default, this call respects the grace period. Set this to `False`, to have the call not respect the grace period associated with the group.
     *
     * For more information about the health check grace period, see [CreateAutoScalingGroup](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html) in the *Amazon EC2 Auto Scaling API Reference*.
     */
    public val shouldRespectGracePeriod: kotlin.Boolean? = builder.shouldRespectGracePeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetInstanceHealthRequest(")
        append("healthStatus=$healthStatus,")
        append("instanceId=$instanceId,")
        append("shouldRespectGracePeriod=$shouldRespectGracePeriod")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthStatus?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (shouldRespectGracePeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetInstanceHealthRequest

        if (healthStatus != other.healthStatus) return false
        if (instanceId != other.instanceId) return false
        if (shouldRespectGracePeriod != other.shouldRespectGracePeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The health status of the instance. Set to `Healthy` to have the instance remain in service. Set to `Unhealthy` to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.
         */
        public var healthStatus: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * If the Auto Scaling group of the specified instance has a `HealthCheckGracePeriod` specified for the group, by default, this call respects the grace period. Set this to `False`, to have the call not respect the grace period associated with the group.
         *
         * For more information about the health check grace period, see [CreateAutoScalingGroup](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html) in the *Amazon EC2 Auto Scaling API Reference*.
         */
        public var shouldRespectGracePeriod: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthRequest) : this() {
            this.healthStatus = x.healthStatus
            this.instanceId = x.instanceId
            this.shouldRespectGracePeriod = x.shouldRespectGracePeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthRequest = SetInstanceHealthRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
