// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes information used for one or more scheduled scaling action updates in a BatchPutScheduledUpdateGroupAction operation.
 */
public class ScheduledUpdateGroupActionRequest private constructor(builder: Builder) {
    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The date and time for the recurring schedule to end, in UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum size of the Auto Scaling group.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the Auto Scaling group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields separated by white spaces: &#91;Minute&#93; &#91;Hour&#93; &#91;Day_of_Month&#93; &#91;Month_of_Year&#93; &#91;Day_of_Week&#93;. The value must be in quotes (for example, `"30 0 1 1,6,12 *"`). For more information about this format, see [Crontab](http://crontab.org).
     *
     * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
     *
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    public val recurrence: kotlin.String? = builder.recurrence
    /**
     * The name of the scaling action.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2019-06-01T00:00:00Z"`).
     *
     * If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
     *
     * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
     *
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
     */
    public val timeZone: kotlin.String? = builder.timeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledUpdateGroupActionRequest(")
        append("desiredCapacity=$desiredCapacity,")
        append("endTime=$endTime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("recurrence=$recurrence,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("timeZone=$timeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = desiredCapacity ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledUpdateGroupActionRequest

        if (desiredCapacity != other.desiredCapacity) return false
        if (endTime != other.endTime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (recurrence != other.recurrence) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupActionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The date and time for the recurring schedule to end, in UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum size of the Auto Scaling group.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the Auto Scaling group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The recurring schedule for the action, in Unix cron syntax format. This format consists of five fields separated by white spaces: &#91;Minute&#93; &#91;Hour&#93; &#91;Day_of_Month&#93; &#91;Month_of_Year&#93; &#91;Day_of_Week&#93;. The value must be in quotes (for example, `"30 0 1 1,6,12 *"`). For more information about this format, see [Crontab](http://crontab.org).
         *
         * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
         *
         * Cron expressions use Universal Coordinated Time (UTC) by default.
         */
        public var recurrence: kotlin.String? = null
        /**
         * The name of the scaling action.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2019-06-01T00:00:00Z"`).
         *
         * If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
         *
         * If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error message.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
         *
         * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
         */
        public var timeZone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupActionRequest) : this() {
            this.desiredCapacity = x.desiredCapacity
            this.endTime = x.endTime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.recurrence = x.recurrence
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupActionRequest = ScheduledUpdateGroupActionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
