// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a scheduled scaling action.
 */
public class ScheduledUpdateGroupAction private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The date and time in UTC for the recurring schedule to end. For example, `"2019-06-01T00:00:00Z"`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum size of the Auto Scaling group.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the Auto Scaling group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The recurring schedule for the action, in Unix cron syntax format.
     *
     * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
     */
    public val recurrence: kotlin.String? = builder.recurrence
    /**
     * The Amazon Resource Name (ARN) of the scheduled action.
     */
    public val scheduledActionArn: kotlin.String? = builder.scheduledActionArn
    /**
     * The name of the scheduled action.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The date and time in UTC for this action to start. For example, `"2019-06-01T00:00:00Z"`.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * This property is no longer used.
     */
    public val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time
    /**
     * The time zone for the cron expression.
     */
    public val timeZone: kotlin.String? = builder.timeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledUpdateGroupAction(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("desiredCapacity=$desiredCapacity,")
        append("endTime=$endTime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("recurrence=$recurrence,")
        append("scheduledActionArn=$scheduledActionArn,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("time=$time,")
        append("timeZone=$timeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionArn?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledUpdateGroupAction

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (endTime != other.endTime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (recurrence != other.recurrence) return false
        if (scheduledActionArn != other.scheduledActionArn) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (time != other.time) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The date and time in UTC for the recurring schedule to end. For example, `"2019-06-01T00:00:00Z"`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum size of the Auto Scaling group.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the Auto Scaling group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The recurring schedule for the action, in Unix cron syntax format.
         *
         * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
         */
        public var recurrence: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the scheduled action.
         */
        public var scheduledActionArn: kotlin.String? = null
        /**
         * The name of the scheduled action.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The date and time in UTC for this action to start. For example, `"2019-06-01T00:00:00Z"`.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This property is no longer used.
         */
        public var time: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time zone for the cron expression.
         */
        public var timeZone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.desiredCapacity = x.desiredCapacity
            this.endTime = x.endTime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.recurrence = x.recurrence
            this.scheduledActionArn = x.scheduledActionArn
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.time = x.time
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction = ScheduledUpdateGroupAction(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
