// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class PutScheduledUpdateGroupActionRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions.
     *
     * You must specify at least one of the following properties: `MaxSize`, `MinSize`, or `DesiredCapacity`.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The date and time for the recurring schedule to end, in UTC. For example, `"2021-06-01T00:00:00Z"`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The maximum size of the Auto Scaling group.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the Auto Scaling group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The recurring schedule for this action. This format consists of five fields separated by white spaces: &#91;Minute&#93; &#91;Hour&#93; &#91;Day_of_Month&#93; &#91;Month_of_Year&#93; &#91;Day_of_Week&#93;. The value must be in quotes (for example, `"30 0 1 1,6,12 *"`). For more information about this format, see [Crontab](http://crontab.org).
     *
     * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
     *
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    public val recurrence: kotlin.String? = builder.recurrence
    /**
     * The name of this scaling action.
     */
    public val scheduledActionName: kotlin.String? = builder.scheduledActionName
    /**
     * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2021-06-01T00:00:00Z"`).
     *
     * If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * This property is no longer used.
     */
    public val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time
    /**
     * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
     *
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
     */
    public val timeZone: kotlin.String? = builder.timeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutScheduledUpdateGroupActionRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("desiredCapacity=$desiredCapacity,")
        append("endTime=$endTime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("recurrence=$recurrence,")
        append("scheduledActionName=$scheduledActionName,")
        append("startTime=$startTime,")
        append("time=$time,")
        append("timeZone=$timeZone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (scheduledActionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutScheduledUpdateGroupActionRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (endTime != other.endTime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (recurrence != other.recurrence) return false
        if (scheduledActionName != other.scheduledActionName) return false
        if (startTime != other.startTime) return false
        if (time != other.time) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions.
         *
         * You must specify at least one of the following properties: `MaxSize`, `MinSize`, or `DesiredCapacity`.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The date and time for the recurring schedule to end, in UTC. For example, `"2021-06-01T00:00:00Z"`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum size of the Auto Scaling group.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the Auto Scaling group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The recurring schedule for this action. This format consists of five fields separated by white spaces: &#91;Minute&#93; &#91;Hour&#93; &#91;Day_of_Month&#93; &#91;Month_of_Year&#93; &#91;Day_of_Week&#93;. The value must be in quotes (for example, `"30 0 1 1,6,12 *"`). For more information about this format, see [Crontab](http://crontab.org).
         *
         * When `StartTime` and `EndTime` are specified with `Recurrence`, they form the boundaries of when the recurring action starts and stops.
         *
         * Cron expressions use Universal Coordinated Time (UTC) by default.
         */
        public var recurrence: kotlin.String? = null
        /**
         * The name of this scaling action.
         */
        public var scheduledActionName: kotlin.String? = null
        /**
         * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2021-06-01T00:00:00Z"`).
         *
         * If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This property is no longer used.
         */
        public var time: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default.
         *
         * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as `Etc/GMT+9` or `Pacific/Tahiti`). For more information, see [https://en.wikipedia.org/wiki/List_of_tz_database_time_zones](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
         */
        public var timeZone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.desiredCapacity = x.desiredCapacity
            this.endTime = x.endTime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.recurrence = x.recurrence
            this.scheduledActionName = x.scheduledActionName
            this.startTime = x.startTime
            this.time = x.time
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionRequest = PutScheduledUpdateGroupActionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
