// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutLifecycleHookRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is `ABANDON`.
     *
     * Valid values: `CONTINUE` | `ABANDON`
     */
    public val defaultResult: kotlin.String? = builder.defaultResult
    /**
     * The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from `30` to `7200` seconds. The default value is `3600` seconds (1 hour).
     */
    public val heartbeatTimeout: kotlin.Int? = builder.heartbeatTimeout
    /**
     * The name of the lifecycle hook.
     */
    public val lifecycleHookName: kotlin.String? = builder.lifecycleHookName
    /**
     * The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
     * + To create a lifecycle hook for scale-out events, specify `autoscaling:EC2_INSTANCE_LAUNCHING`.
     * + To create a lifecycle hook for scale-in events, specify `autoscaling:EC2_INSTANCE_TERMINATING`.
     *
     * Required for new lifecycle hooks, but optional when updating existing hooks.
     */
    public val lifecycleTransition: kotlin.String? = builder.lifecycleTransition
    /**
     * Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
     */
    public val notificationMetadata: kotlin.String? = builder.notificationMetadata
    /**
     * The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS topic or an Amazon SQS queue.
     *
     * If you specify an empty string, this overrides the current ARN.
     *
     * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.
     *
     * When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: `"Event": "autoscaling:TEST_NOTIFICATION"`.
     */
    public val notificationTargetArn: kotlin.String? = builder.notificationTargetArn
    /**
     * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     *
     * Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutLifecycleHookRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("defaultResult=$defaultResult,")
        append("heartbeatTimeout=$heartbeatTimeout,")
        append("lifecycleHookName=$lifecycleHookName,")
        append("lifecycleTransition=$lifecycleTransition,")
        append("notificationMetadata=$notificationMetadata,")
        append("notificationTargetArn=$notificationTargetArn,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (defaultResult?.hashCode() ?: 0)
        result = 31 * result + (heartbeatTimeout ?: 0)
        result = 31 * result + (lifecycleHookName?.hashCode() ?: 0)
        result = 31 * result + (lifecycleTransition?.hashCode() ?: 0)
        result = 31 * result + (notificationMetadata?.hashCode() ?: 0)
        result = 31 * result + (notificationTargetArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutLifecycleHookRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (defaultResult != other.defaultResult) return false
        if (heartbeatTimeout != other.heartbeatTimeout) return false
        if (lifecycleHookName != other.lifecycleHookName) return false
        if (lifecycleTransition != other.lifecycleTransition) return false
        if (notificationMetadata != other.notificationMetadata) return false
        if (notificationTargetArn != other.notificationTargetArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. The default value is `ABANDON`.
         *
         * Valid values: `CONTINUE` | `ABANDON`
         */
        public var defaultResult: kotlin.String? = null
        /**
         * The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from `30` to `7200` seconds. The default value is `3600` seconds (1 hour).
         */
        public var heartbeatTimeout: kotlin.Int? = null
        /**
         * The name of the lifecycle hook.
         */
        public var lifecycleHookName: kotlin.String? = null
        /**
         * The lifecycle transition. For Auto Scaling groups, there are two major lifecycle transitions.
         * + To create a lifecycle hook for scale-out events, specify `autoscaling:EC2_INSTANCE_LAUNCHING`.
         * + To create a lifecycle hook for scale-in events, specify `autoscaling:EC2_INSTANCE_TERMINATING`.
         *
         * Required for new lifecycle hooks, but optional when updating existing hooks.
         */
        public var lifecycleTransition: kotlin.String? = null
        /**
         * Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.
         */
        public var notificationMetadata: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in a wait state for the lifecycle hook. You can specify either an Amazon SNS topic or an Amazon SQS queue.
         *
         * If you specify an empty string, this overrides the current ARN.
         *
         * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.
         *
         * When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: `"Event": "autoscaling:TEST_NOTIFICATION"`.
         */
        public var notificationTargetArn: kotlin.String? = null
        /**
         * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
         *
         * Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.defaultResult = x.defaultResult
            this.heartbeatTimeout = x.heartbeatTimeout
            this.lifecycleHookName = x.lifecycleHookName
            this.lifecycleTransition = x.lifecycleTransition
            this.notificationMetadata = x.notificationMetadata
            this.notificationTargetArn = x.notificationTargetArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookRequest = PutLifecycleHookRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
