// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
 *
 * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class MixedInstancesPolicy private constructor(builder: Builder) {
    /**
     * The instances distribution.
     */
    public val instancesDistribution: aws.sdk.kotlin.services.autoscaling.model.InstancesDistribution? = builder.instancesDistribution
    /**
     * One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplate? = builder.launchTemplate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MixedInstancesPolicy(")
        append("instancesDistribution=$instancesDistribution,")
        append("launchTemplate=$launchTemplate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instancesDistribution?.hashCode() ?: 0
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MixedInstancesPolicy

        if (instancesDistribution != other.instancesDistribution) return false
        if (launchTemplate != other.launchTemplate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instances distribution.
         */
        public var instancesDistribution: aws.sdk.kotlin.services.autoscaling.model.InstancesDistribution? = null
        /**
         * One or more launch templates and the instance types (overrides) that are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy) : this() {
            this.instancesDistribution = x.instancesDistribution
            this.launchTemplate = x.launchTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy = MixedInstancesPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstancesDistribution] inside the given [block]
         */
        public fun instancesDistribution(block: aws.sdk.kotlin.services.autoscaling.model.InstancesDistribution.Builder.() -> kotlin.Unit) {
            this.instancesDistribution = aws.sdk.kotlin.services.autoscaling.model.InstancesDistribution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplate] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplate.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
