// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this structure to let Amazon EC2 Auto Scaling do the following when the Auto Scaling group has a mixed instances policy:
 * + Override the instance type that is specified in the launch template.
 * + Use multiple instance types.
 *
 * Specify the instance types that you want, or define your instance requirements instead and let Amazon EC2 Auto Scaling provision the available instance types that meet your requirements. This can provide Amazon EC2 Auto Scaling with a larger selection of instance types to choose from when fulfilling Spot and On-Demand capacities. You can view which instance types are matched before you apply the instance requirements to your Auto Scaling group.
 *
 * After you define your instance requirements, you don't have to keep updating these settings to get new EC2 instance types automatically. Amazon EC2 Auto Scaling uses the instance requirements of the Auto Scaling group to determine whether a new EC2 instance type can be used.
 */
public class LaunchTemplateOverrides private constructor(builder: Builder) {
    /**
     * The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
     *
     * You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template.
     *
     * If you specify `InstanceRequirements`, you can't specify `InstanceType`.
     */
    public val instanceRequirements: aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements? = builder.instanceRequirements
    /**
     * The instance type, such as `m3.xlarge`. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*.
     *
     * You can specify up to 40 instance types per Auto Scaling group.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the `LaunchTemplate` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the `LaunchTemplate` definition count towards this limit.
     */
    public val launchTemplateSpecification: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplateSpecification
    /**
     * If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a `WeightedCapacity` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configuring instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1–999.
     *
     * If you specify a value for `WeightedCapacity` for one instance type, you must specify a value for `WeightedCapacity` for all of them.
     *
     * Every Auto Scaling group has three size parameters (`DesiredCapacity`, `MaxSize`, and `MinSize`). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
     */
    public val weightedCapacity: kotlin.String? = builder.weightedCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateOverrides = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateOverrides(")
        append("instanceRequirements=$instanceRequirements,")
        append("instanceType=$instanceType,")
        append("launchTemplateSpecification=$launchTemplateSpecification,")
        append("weightedCapacity=$weightedCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceRequirements?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateSpecification?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateOverrides

        if (instanceRequirements != other.instanceRequirements) return false
        if (instanceType != other.instanceType) return false
        if (launchTemplateSpecification != other.launchTemplateSpecification) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateOverrides = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instance requirements. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
         *
         * You can specify up to four separate sets of instance requirements per Auto Scaling group. This is useful for provisioning instances from different Amazon Machine Images (AMIs) in the same Auto Scaling group. To do this, create the AMIs and create a new launch template for each AMI. Then, create a compatible set of instance requirements for each launch template.
         *
         * If you specify `InstanceRequirements`, you can't specify `InstanceType`.
         */
        public var instanceRequirements: aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements? = null
        /**
         * The instance type, such as `m3.xlarge`. You must specify an instance type that is supported in your requested Region and Availability Zones. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon Elastic Compute Cloud User Guide*.
         *
         * You can specify up to 40 instance types per Auto Scaling group.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Provides a launch template for the specified instance type or set of instance requirements. For example, some instance types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's specified in the `LaunchTemplate` definition. For more information, see [Specifying a different launch template for an instance type](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * You can specify up to 20 launch templates per Auto Scaling group. The launch templates specified in the overrides and in the `LaunchTemplate` definition count towards this limit.
         */
        public var launchTemplateSpecification: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * If you provide a list of instance types to use, you can specify the number of capacity units provided by each instance type in terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a `WeightedCapacity` of five units, the instance is launched, and the desired capacity is exceeded by three units. For more information, see [Configuring instance weighting for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html) in the *Amazon EC2 Auto Scaling User Guide*. Value must be in the range of 1–999.
         *
         * If you specify a value for `WeightedCapacity` for one instance type, you must specify a value for `WeightedCapacity` for all of them.
         *
         * Every Auto Scaling group has three size parameters (`DesiredCapacity`, `MaxSize`, and `MinSize`). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
         */
        public var weightedCapacity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateOverrides) : this() {
            this.instanceRequirements = x.instanceRequirements
            this.instanceType = x.instanceType
            this.launchTemplateSpecification = x.launchTemplateSpecification
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateOverrides = LaunchTemplateOverrides(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements] inside the given [block]
         */
        public fun instanceRequirements(block: aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements.Builder.() -> kotlin.Unit) {
            this.instanceRequirements = aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplateSpecification(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplateSpecification = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
