// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance refresh for an Auto Scaling group.
 */
public class InstanceRefresh private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * Describes the desired configuration for the instance refresh.
     */
    public val desiredConfiguration: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration? = builder.desiredConfiguration
    /**
     * The date and time at which the instance refresh ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The instance refresh ID.
     */
    public val instanceRefreshId: kotlin.String? = builder.instanceRefreshId
    /**
     * The number of instances remaining to update before the instance refresh is complete.
     *
     * If you roll back the instance refresh, `InstancesToUpdate` shows you the number of instances that were not yet updated by the instance refresh. Therefore, these instances don't need to be replaced as part of the rollback.
     */
    public val instancesToUpdate: kotlin.Int? = builder.instancesToUpdate
    /**
     * The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the instance's health status changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage complete.
     *
     * `PercentageComplete` does not include instances that are replaced during a rollback. This value gradually goes back down to zero during a rollback.
     */
    public val percentageComplete: kotlin.Int? = builder.percentageComplete
    /**
     * The preferences for an instance refresh.
     */
    public val preferences: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences? = builder.preferences
    /**
     * Additional progress details for an Auto Scaling group that has a warm pool.
     */
    public val progressDetails: aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshProgressDetails? = builder.progressDetails
    /**
     * The rollback details.
     */
    public val rollbackDetails: aws.sdk.kotlin.services.autoscaling.model.RollbackDetails? = builder.rollbackDetails
    /**
     * The date and time at which the instance refresh began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status for the instance refresh operation:
     * + `Pending` - The request was created, but the instance refresh has not started.
     * + `InProgress` - An instance refresh is in progress.
     * + `Successful` - An instance refresh completed successfully.
     * + `Failed` - An instance refresh failed to complete. You can troubleshoot using the status reason and the scaling activities.
     * + `Cancelling` - An ongoing instance refresh is being cancelled.
     * + `Cancelled` - The instance refresh is cancelled.
     * + `RollbackInProgress` - An instance refresh is being rolled back.
     * + `RollbackFailed` - The rollback failed to complete. You can troubleshoot using the status reason and the scaling activities.
     * + `RollbackSuccessful` - The rollback completed successfully.
     */
    public val status: aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshStatus? = builder.status
    /**
     * The explanation for the specific status assigned to this operation.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.InstanceRefresh = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceRefresh(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("desiredConfiguration=$desiredConfiguration,")
        append("endTime=$endTime,")
        append("instanceRefreshId=$instanceRefreshId,")
        append("instancesToUpdate=$instancesToUpdate,")
        append("percentageComplete=$percentageComplete,")
        append("preferences=$preferences,")
        append("progressDetails=$progressDetails,")
        append("rollbackDetails=$rollbackDetails,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (desiredConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (instanceRefreshId?.hashCode() ?: 0)
        result = 31 * result + (instancesToUpdate ?: 0)
        result = 31 * result + (percentageComplete ?: 0)
        result = 31 * result + (preferences?.hashCode() ?: 0)
        result = 31 * result + (progressDetails?.hashCode() ?: 0)
        result = 31 * result + (rollbackDetails?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceRefresh

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (desiredConfiguration != other.desiredConfiguration) return false
        if (endTime != other.endTime) return false
        if (instanceRefreshId != other.instanceRefreshId) return false
        if (instancesToUpdate != other.instancesToUpdate) return false
        if (percentageComplete != other.percentageComplete) return false
        if (preferences != other.preferences) return false
        if (progressDetails != other.progressDetails) return false
        if (rollbackDetails != other.rollbackDetails) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.InstanceRefresh = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * Describes the desired configuration for the instance refresh.
         */
        public var desiredConfiguration: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration? = null
        /**
         * The date and time at which the instance refresh ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The instance refresh ID.
         */
        public var instanceRefreshId: kotlin.String? = null
        /**
         * The number of instances remaining to update before the instance refresh is complete.
         *
         * If you roll back the instance refresh, `InstancesToUpdate` shows you the number of instances that were not yet updated by the instance refresh. Therefore, these instances don't need to be replaced as part of the rollback.
         */
        public var instancesToUpdate: kotlin.Int? = null
        /**
         * The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the instance's health status changes to healthy and the specified warm-up time passes, the instance is considered updated and is added to the percentage complete.
         *
         * `PercentageComplete` does not include instances that are replaced during a rollback. This value gradually goes back down to zero during a rollback.
         */
        public var percentageComplete: kotlin.Int? = null
        /**
         * The preferences for an instance refresh.
         */
        public var preferences: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences? = null
        /**
         * Additional progress details for an Auto Scaling group that has a warm pool.
         */
        public var progressDetails: aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshProgressDetails? = null
        /**
         * The rollback details.
         */
        public var rollbackDetails: aws.sdk.kotlin.services.autoscaling.model.RollbackDetails? = null
        /**
         * The date and time at which the instance refresh began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status for the instance refresh operation:
         * + `Pending` - The request was created, but the instance refresh has not started.
         * + `InProgress` - An instance refresh is in progress.
         * + `Successful` - An instance refresh completed successfully.
         * + `Failed` - An instance refresh failed to complete. You can troubleshoot using the status reason and the scaling activities.
         * + `Cancelling` - An ongoing instance refresh is being cancelled.
         * + `Cancelled` - The instance refresh is cancelled.
         * + `RollbackInProgress` - An instance refresh is being rolled back.
         * + `RollbackFailed` - The rollback failed to complete. You can troubleshoot using the status reason and the scaling activities.
         * + `RollbackSuccessful` - The rollback completed successfully.
         */
        public var status: aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshStatus? = null
        /**
         * The explanation for the specific status assigned to this operation.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.InstanceRefresh) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.desiredConfiguration = x.desiredConfiguration
            this.endTime = x.endTime
            this.instanceRefreshId = x.instanceRefreshId
            this.instancesToUpdate = x.instancesToUpdate
            this.percentageComplete = x.percentageComplete
            this.preferences = x.preferences
            this.progressDetails = x.progressDetails
            this.rollbackDetails = x.rollbackDetails
            this.startTime = x.startTime
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.InstanceRefresh = InstanceRefresh(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration] inside the given [block]
         */
        public fun desiredConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration.Builder.() -> kotlin.Unit) {
            this.desiredConfiguration = aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences] inside the given [block]
         */
        public fun preferences(block: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences.Builder.() -> kotlin.Unit) {
            this.preferences = aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshProgressDetails] inside the given [block]
         */
        public fun progressDetails(block: aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshProgressDetails.Builder.() -> kotlin.Unit) {
            this.progressDetails = aws.sdk.kotlin.services.autoscaling.model.InstanceRefreshProgressDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.RollbackDetails] inside the given [block]
         */
        public fun rollbackDetails(block: aws.sdk.kotlin.services.autoscaling.model.RollbackDetails.Builder.() -> kotlin.Unit) {
            this.rollbackDetails = aws.sdk.kotlin.services.autoscaling.model.RollbackDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
