// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class InstanceMetadataOptions private constructor(builder: Builder) {
    /**
     * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is `enabled`.
     *
     * If you specify a value of `disabled`, you will not be able to access your instance metadata.
     */
    public val httpEndpoint: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataEndpointState? = builder.httpEndpoint
    /**
     * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.
     *
     * Default: 1
     */
    public val httpPutResponseHopLimit: kotlin.Int? = builder.httpPutResponseHopLimit
    /**
     * The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is `optional`.
     *
     * If the state is `optional`, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.
     *
     * If the state is `required`, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.
     */
    public val httpTokens: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataHttpTokensState? = builder.httpTokens

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceMetadataOptions(")
        append("httpEndpoint=$httpEndpoint,")
        append("httpPutResponseHopLimit=$httpPutResponseHopLimit,")
        append("httpTokens=$httpTokens")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpEndpoint?.hashCode() ?: 0
        result = 31 * result + (httpPutResponseHopLimit ?: 0)
        result = 31 * result + (httpTokens?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceMetadataOptions

        if (httpEndpoint != other.httpEndpoint) return false
        if (httpPutResponseHopLimit != other.httpPutResponseHopLimit) return false
        if (httpTokens != other.httpTokens) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is `enabled`.
         *
         * If you specify a value of `disabled`, you will not be able to access your instance metadata.
         */
        public var httpEndpoint: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataEndpointState? = null
        /**
         * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.
         *
         * Default: 1
         */
        public var httpPutResponseHopLimit: kotlin.Int? = null
        /**
         * The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is `optional`.
         *
         * If the state is `optional`, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.
         *
         * If the state is `required`, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.
         */
        public var httpTokens: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataHttpTokensState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions) : this() {
            this.httpEndpoint = x.httpEndpoint
            this.httpPutResponseHopLimit = x.httpPutResponseHopLimit
            this.httpTokens = x.httpTokens
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions = InstanceMetadataOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
