// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an enabled Auto Scaling group metric.
 */
public class EnabledMetric private constructor(builder: Builder) {
    /**
     * The granularity of the metric. The only valid value is `1Minute`.
     */
    public val granularity: kotlin.String? = builder.granularity
    /**
     * One of the following metrics:
     * + `GroupMinSize`
     * + `GroupMaxSize`
     * + `GroupDesiredCapacity`
     * + `GroupInServiceInstances`
     * + `GroupPendingInstances`
     * + `GroupStandbyInstances`
     * + `GroupTerminatingInstances`
     * + `GroupTotalInstances`
     * + `GroupInServiceCapacity`
     * + `GroupPendingCapacity`
     * + `GroupStandbyCapacity`
     * + `GroupTerminatingCapacity`
     * + `GroupTotalCapacity`
     * + `WarmPoolDesiredCapacity`
     * + `WarmPoolWarmedCapacity`
     * + `WarmPoolPendingCapacity`
     * + `WarmPoolTerminatingCapacity`
     * + `WarmPoolTotalCapacity`
     * + `GroupAndWarmPoolDesiredCapacity`
     * + `GroupAndWarmPoolTotalCapacity`
     *
     * For more information, see [Auto Scaling group metrics](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val metric: kotlin.String? = builder.metric

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.EnabledMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnabledMetric(")
        append("granularity=$granularity,")
        append("metric=$metric")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = granularity?.hashCode() ?: 0
        result = 31 * result + (metric?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnabledMetric

        if (granularity != other.granularity) return false
        if (metric != other.metric) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.EnabledMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The granularity of the metric. The only valid value is `1Minute`.
         */
        public var granularity: kotlin.String? = null
        /**
         * One of the following metrics:
         * + `GroupMinSize`
         * + `GroupMaxSize`
         * + `GroupDesiredCapacity`
         * + `GroupInServiceInstances`
         * + `GroupPendingInstances`
         * + `GroupStandbyInstances`
         * + `GroupTerminatingInstances`
         * + `GroupTotalInstances`
         * + `GroupInServiceCapacity`
         * + `GroupPendingCapacity`
         * + `GroupStandbyCapacity`
         * + `GroupTerminatingCapacity`
         * + `GroupTotalCapacity`
         * + `WarmPoolDesiredCapacity`
         * + `WarmPoolWarmedCapacity`
         * + `WarmPoolPendingCapacity`
         * + `WarmPoolTerminatingCapacity`
         * + `WarmPoolTotalCapacity`
         * + `GroupAndWarmPoolDesiredCapacity`
         * + `GroupAndWarmPoolTotalCapacity`
         *
         * For more information, see [Auto Scaling group metrics](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var metric: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.EnabledMetric) : this() {
            this.granularity = x.granularity
            this.metric = x.metric
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.EnabledMetric = EnabledMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
