// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeTrafficSourcesRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The maximum number of items to return with this call. The maximum value is `50`.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The token for the next set of items to return. (You received this token from a previous call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The traffic source type that you want to describe.
     *
     * The following lists the valid values:
     * + `elb` if the traffic source is a Classic Load Balancer.
     * + `elbv2` if the traffic source is a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer.
     * + `vpc-lattice` if the traffic source is VPC Lattice.
     */
    public val trafficSourceType: kotlin.String? = builder.trafficSourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTrafficSourcesRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken,")
        append("trafficSourceType=$trafficSourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (trafficSourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTrafficSourcesRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false
        if (trafficSourceType != other.trafficSourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The maximum number of items to return with this call. The maximum value is `50`.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The token for the next set of items to return. (You received this token from a previous call.)
         */
        public var nextToken: kotlin.String? = null
        /**
         * The traffic source type that you want to describe.
         *
         * The following lists the valid values:
         * + `elb` if the traffic source is a Classic Load Balancer.
         * + `elbv2` if the traffic source is a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer.
         * + `vpc-lattice` if the traffic source is VPC Lattice.
         */
        public var trafficSourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
            this.trafficSourceType = x.trafficSourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest = DescribeTrafficSourcesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
