// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a block device mapping.
 */
public class BlockDeviceMapping private constructor(builder: Builder) {
    /**
     * The device name assigned to the volume (for example, `/dev/sdh` or `xvdh`). For more information, see [Device naming on Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * To define a block device mapping, set the device name and exactly one of the following properties: `Ebs`, `NoDevice`, or `VirtualName`.
     */
    public val deviceName: kotlin.String? = builder.deviceName
    /**
     * Information to attach an EBS volume to an instance at launch.
     */
    public val ebs: aws.sdk.kotlin.services.autoscaling.model.Ebs? = builder.ebs
    /**
     * Setting this value to `true` prevents a volume that is included in the block device mapping of the AMI from being mapped to the specified device name at launch.
     *
     * If `NoDevice` is `true` for the root device, instances might fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
     */
    public val noDevice: kotlin.Boolean? = builder.noDevice
    /**
     * The name of the instance store volume (virtual device) to attach to an instance at launch. The name must be in the form ephemeral*X* where *X* is a number starting from zero (0), for example, `ephemeral0`.
     */
    public val virtualName: kotlin.String? = builder.virtualName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.BlockDeviceMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockDeviceMapping(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockDeviceMapping

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.BlockDeviceMapping = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The device name assigned to the volume (for example, `/dev/sdh` or `xvdh`). For more information, see [Device naming on Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * To define a block device mapping, set the device name and exactly one of the following properties: `Ebs`, `NoDevice`, or `VirtualName`.
         */
        public var deviceName: kotlin.String? = null
        /**
         * Information to attach an EBS volume to an instance at launch.
         */
        public var ebs: aws.sdk.kotlin.services.autoscaling.model.Ebs? = null
        /**
         * Setting this value to `true` prevents a volume that is included in the block device mapping of the AMI from being mapped to the specified device name at launch.
         *
         * If `NoDevice` is `true` for the root device, instances might fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
         */
        public var noDevice: kotlin.Boolean? = null
        /**
         * The name of the instance store volume (virtual device) to attach to an instance at launch. The name must be in the form ephemeral*X* where *X* is a number starting from zero (0), for example, `ephemeral0`.
         */
        public var virtualName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.BlockDeviceMapping) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.BlockDeviceMapping = BlockDeviceMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.Ebs] inside the given [block]
         */
        public fun ebs(block: aws.sdk.kotlin.services.autoscaling.model.Ebs.Builder.() -> kotlin.Unit) {
            this.ebs = aws.sdk.kotlin.services.autoscaling.model.Ebs.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
