// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes scaling activity, which is a long-running process that represents a change to your Auto Scaling group, such as changing its size or replacing an instance.
 */
public class Activity private constructor(builder: Builder) {
    /**
     * The ID of the activity.
     */
    public val activityId: kotlin.String? = builder.activityId
    /**
     * The Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public val autoScalingGroupArn: kotlin.String? = builder.autoScalingGroupArn
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The state of the Auto Scaling group, which is either `InService` or `Deleted`.
     */
    public val autoScalingGroupState: kotlin.String? = builder.autoScalingGroupState
    /**
     * The reason the activity began.
     */
    public val cause: kotlin.String? = builder.cause
    /**
     * A friendly, more verbose description of the activity.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The details about the activity.
     */
    public val details: kotlin.String? = builder.details
    /**
     * The end time of the activity.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A value between 0 and 100 that indicates the progress of the activity.
     */
    public val progress: kotlin.Int? = builder.progress
    /**
     * The start time of the activity.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status of the activity.
     */
    public val statusCode: aws.sdk.kotlin.services.autoscaling.model.ScalingActivityStatusCode? = builder.statusCode
    /**
     * A friendly, more verbose description of the activity status.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.Activity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Activity(")
        append("activityId=$activityId,")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("autoScalingGroupState=$autoScalingGroupState,")
        append("cause=$cause,")
        append("description=$description,")
        append("details=$details,")
        append("endTime=$endTime,")
        append("progress=$progress,")
        append("startTime=$startTime,")
        append("statusCode=$statusCode,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupArn?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroupState?.hashCode() ?: 0)
        result = 31 * result + (cause?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (progress ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Activity

        if (activityId != other.activityId) return false
        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (autoScalingGroupState != other.autoScalingGroupState) return false
        if (cause != other.cause) return false
        if (description != other.description) return false
        if (details != other.details) return false
        if (endTime != other.endTime) return false
        if (progress != other.progress) return false
        if (startTime != other.startTime) return false
        if (statusCode != other.statusCode) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.Activity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the activity.
         */
        public var activityId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Auto Scaling group.
         */
        public var autoScalingGroupArn: kotlin.String? = null
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The state of the Auto Scaling group, which is either `InService` or `Deleted`.
         */
        public var autoScalingGroupState: kotlin.String? = null
        /**
         * The reason the activity began.
         */
        public var cause: kotlin.String? = null
        /**
         * A friendly, more verbose description of the activity.
         */
        public var description: kotlin.String? = null
        /**
         * The details about the activity.
         */
        public var details: kotlin.String? = null
        /**
         * The end time of the activity.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value between 0 and 100 that indicates the progress of the activity.
         */
        public var progress: kotlin.Int? = null
        /**
         * The start time of the activity.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the activity.
         */
        public var statusCode: aws.sdk.kotlin.services.autoscaling.model.ScalingActivityStatusCode? = null
        /**
         * A friendly, more verbose description of the activity status.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.Activity) : this() {
            this.activityId = x.activityId
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.autoScalingGroupName = x.autoScalingGroupName
            this.autoScalingGroupState = x.autoScalingGroupState
            this.cause = x.cause
            this.description = x.description
            this.details = x.details
            this.endTime = x.endTime
            this.progress = x.progress
            this.startTime = x.startTime
            this.statusCode = x.statusCode
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.Activity = Activity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
