// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.RollbackInstanceRefreshResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RollbackInstanceRefreshOperationDeserializer: HttpDeserialize<RollbackInstanceRefreshResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RollbackInstanceRefreshResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRollbackInstanceRefreshError(context, call)
        }
        val builder = RollbackInstanceRefreshResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRollbackInstanceRefreshOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRollbackInstanceRefreshError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceeded" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "ActiveInstanceRefreshNotFound" -> ActiveInstanceRefreshNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "IrreversibleInstanceRefresh" -> IrreversibleInstanceRefreshFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRollbackInstanceRefreshOperationBody(builder: RollbackInstanceRefreshResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RollbackInstanceRefreshResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RollbackInstanceRefreshResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RollbackInstanceRefresh response")
    }
    // end unwrap response wrapper

    val INSTANCEREFRESHID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("InstanceRefreshId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("RollbackInstanceRefreshResult"))
        field(INSTANCEREFRESHID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCEREFRESHID_DESCRIPTOR.index -> builder.instanceRefreshId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
